/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.script;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.Check;

public final class Scripts {
    public static final String DOC_VALUE = "doc[{}].value";
    public static final String QL_SCRIPTS = "{ql}";
    public static final String EQL_SCRIPTS = "{eql}";
    public static final String SQL_SCRIPTS = "{sql}";
    public static final String PARAM = "{}";
    static final String DOC_VALUE_PARAMS_REGEX = "InternalQlScriptUtils\\.docValue\\(doc,(params\\.%s)\\)|(params\\.%s)|InternalQlScriptUtils\\.not\\(";
    public static final String INTERNAL_QL_SCRIPT_UTILS = "InternalQlScriptUtils";
    public static final String INTERNAL_EQL_SCRIPT_UTILS = "InternalEqlScriptUtils";
    public static final String INTERNAL_SQL_SCRIPT_UTILS = "InternalSqlScriptUtils";
    private static final int PKG_LENGTH = "org.elasticsearch.xpack.".length();
    static final Map<Pattern, String> FORMATTING_PATTERNS = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("doc[{}].value", "{ql}.docValue(doc,{})"), new AbstractMap.SimpleEntry<String, String>("{ql}", "InternalQlScriptUtils"), new AbstractMap.SimpleEntry<String, String>("{eql}", "InternalEqlScriptUtils"), new AbstractMap.SimpleEntry<String, String>("{sql}", "InternalSqlScriptUtils"), new AbstractMap.SimpleEntry<String, String>("{}", "params.%s")).collect(Collectors.toMap(e -> Pattern.compile((String)e.getKey(), 16), Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new)));
    static final Pattern qlDocValuePattern = Pattern.compile("InternalQlScriptUtils\\.docValue\\(doc,(params\\.%s)\\)|(params\\.%s)|InternalQlScriptUtils\\.not\\(");

    private Scripts() {
    }

    public static String formatTemplate(String template) {
        for (Map.Entry<Pattern, String> entry : FORMATTING_PATTERNS.entrySet()) {
            template = entry.getKey().matcher(template).replaceAll(entry.getValue());
        }
        return template;
    }

    public static ScriptTemplate nullSafeFilter(ScriptTemplate script) {
        return new ScriptTemplate(Scripts.formatTemplate(String.format(Locale.ROOT, "{ql}.nullSafeFilter(%s)", script.template())), script.params(), DataTypes.BOOLEAN);
    }

    public static ScriptTemplate nullSafeSort(ScriptTemplate script) {
        String methodName = script.outputType().isNumeric() ? "nullSafeSortNumeric" : "nullSafeSortString";
        return new ScriptTemplate(Scripts.formatTemplate(String.format(Locale.ROOT, "{ql}.%s(%s)", methodName, script.template())), script.params(), script.outputType());
    }

    public static ScriptTemplate and(ScriptTemplate left, ScriptTemplate right) {
        return Scripts.binaryMethod(QL_SCRIPTS, "and", left, right, DataTypes.BOOLEAN);
    }

    public static ScriptTemplate or(ScriptTemplate left, ScriptTemplate right) {
        return Scripts.binaryMethod(QL_SCRIPTS, "or", left, right, DataTypes.BOOLEAN);
    }

    public static ScriptTemplate binaryMethod(String prefix, String methodName, ScriptTemplate leftScript, ScriptTemplate rightScript, DataType dataType) {
        return new ScriptTemplate(String.format(Locale.ROOT, Scripts.formatTemplate("%s.%s(%s,%s)"), Scripts.formatTemplate(prefix), methodName, leftScript.template(), rightScript.template()), ParamsBuilder.paramsBuilder().script(leftScript.params()).script(rightScript.params()).build(), dataType);
    }

    public static String classPackageAsPrefix(Class<?> function) {
        String prefix = function.getPackageName().substring(PKG_LENGTH);
        int index = prefix.indexOf(46);
        Check.isTrue(index > 0, "invalid package {}", prefix);
        return "{" + prefix.substring(0, index) + "}";
    }

    public static ScriptTemplate multiValueDocValuesRewrite(ScriptTemplate script) {
        return Scripts.docValuesRewrite(script, false);
    }

    private static ScriptTemplate docValuesRewrite(ScriptTemplate script, boolean useSameValueInScript) {
        String[] tokens;
        int index = 0;
        Map<String, Object> params = script.params().asParams();
        ArrayList<Object> fieldVars = new ArrayList<Object>();
        ArrayList<Object> otherVars = new ArrayList<Object>();
        StringBuilder newTemplate = new StringBuilder();
        int negated = 0;
        for (String token : tokens = Scripts.splitWithMatches(script.template(), qlDocValuePattern)) {
            if ("InternalQlScriptUtils.docValue(doc,params.%s)".equals(token)) {
                Object fieldName = params.get("v" + index);
                if (useSameValueInScript) {
                    if (!fieldVars.contains(fieldName)) {
                        fieldVars.add(fieldName);
                    }
                    newTemplate.append("X" + fieldVars.indexOf(fieldName));
                } else {
                    fieldVars.add(fieldName);
                    newTemplate.append("X" + (fieldVars.size() - 1));
                }
                ++index;
            } else if ("InternalQlScriptUtils.not(".equals(token)) {
                ++negated;
            } else if ("params.%s".equals(token)) {
                newTemplate.append(token);
                otherVars.add(params.get("v" + index));
                ++index;
            } else {
                newTemplate.append(token);
            }
            for (int i = 0; i < negated - 1; ++i) {
                newTemplate.deleteCharAt(newTemplate.length() - 1);
            }
        }
        for (int i = fieldVars.size() - 1; i >= 0; --i) {
            newTemplate.insert(0, "InternalEqlScriptUtils.multiValueDocValues(doc,params.%s,X" + i + " -> ");
            newTemplate.append(")");
        }
        if (negated > 0) {
            newTemplate.insert(0, "InternalQlScriptUtils.not(");
        }
        ParamsBuilder newParams = ParamsBuilder.paramsBuilder();
        fieldVars.forEach(v -> newParams.variable(v));
        otherVars.forEach(v -> newParams.variable(v));
        return new ScriptTemplate(newTemplate.toString(), newParams.build(), DataTypes.BOOLEAN);
    }

    static String[] splitWithMatches(String input, Pattern pattern) {
        int index = 0;
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher m = pattern.matcher(input);
        while (m.find()) {
            if (index != m.start()) {
                matchList.add(input.subSequence(index, m.start()).toString());
            }
            if (m.start() != m.end()) {
                matchList.add(input.subSequence(m.start(), m.end()).toString());
            }
            index = m.end();
        }
        if (index == 0) {
            return new String[]{input};
        }
        if (index < input.length()) {
            matchList.add(input.subSequence(index, input.length()).toString());
        }
        return matchList.toArray(new String[matchList.size()]);
    }
}

