/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function.scalar;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.UnaryPipe;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;

public abstract class UnaryScalarFunction
extends ScalarFunction {
    private final Expression field;

    protected UnaryScalarFunction(Source source) {
        super(source);
        this.field = null;
    }

    protected UnaryScalarFunction(Source source, Expression field) {
        super(source, Collections.singletonList(field));
        this.field = field;
    }

    @Override
    public final UnaryScalarFunction replaceChildren(List<Expression> newChildren) {
        return this.replaceChild(newChildren.get(0));
    }

    protected abstract UnaryScalarFunction replaceChild(Expression var1);

    public Expression field() {
        return this.field;
    }

    @Override
    public final Pipe makePipe() {
        return new UnaryPipe(this.source(), this, Expressions.pipe(this.field()), this.makeProcessor());
    }

    protected abstract Processor makeProcessor();

    @Override
    public boolean foldable() {
        return this.field.foldable();
    }

    @Override
    public Object fold() {
        return this.makeProcessor().process(this.field().fold());
    }

    @Override
    public ScriptTemplate asScript() {
        return this.asScript(this.field);
    }
}

