/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.LeafExpression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;

public class Literal
extends LeafExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Literal", Literal::readFrom);
    public static final Literal TRUE = new Literal(Source.EMPTY, Boolean.TRUE, DataType.BOOLEAN);
    public static final Literal FALSE = new Literal(Source.EMPTY, Boolean.FALSE, DataType.BOOLEAN);
    public static final Literal NULL = new Literal(Source.EMPTY, null, DataType.NULL);
    private final Object value;
    private final DataType dataType;

    public Literal(Source source, Object value, DataType dataType) {
        super(source);
        this.dataType = dataType;
        this.value = value;
    }

    private static Literal readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        Object value = in.readGenericValue();
        DataType dataType = DataType.readFrom(in);
        return new Literal(source, Literal.mapToLiteralValue(in, dataType, value), dataType);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeGenericValue(Literal.mapFromLiteralValue(out, this.dataType, this.value));
        this.dataType.writeTo(out);
    }

    public String getWriteableName() {
        return Literal.ENTRY.name;
    }

    @Override
    protected NodeInfo<? extends Literal> info() {
        return NodeInfo.create(this, Literal::new, this.value, this.dataType);
    }

    public Object value() {
        return this.value;
    }

    @Override
    public boolean foldable() {
        return true;
    }

    @Override
    public Nullability nullable() {
        return this.value == null ? Nullability.TRUE : Nullability.FALSE;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public boolean resolved() {
        return true;
    }

    @Override
    public Object fold(FoldContext ctx) {
        return this.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.dataType, this.value});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Literal other = (Literal)obj;
        return Objects.equals(this.value, other.value) && Objects.equals((Object)this.dataType, (Object)other.dataType);
    }

    @Override
    public String toString() {
        String str = String.valueOf(this.value);
        if (str.length() > 500) {
            return str.substring(0, 500) + "...";
        }
        return str;
    }

    @Override
    public String nodeString() {
        return this.toString() + "[" + String.valueOf((Object)this.dataType) + "]";
    }

    public static Literal of(FoldContext ctx, Expression foldable) {
        if (!foldable.foldable()) {
            throw new QlIllegalArgumentException("Foldable expression required for Literal creation; received unfoldable " + String.valueOf(foldable));
        }
        if (foldable instanceof Literal) {
            return (Literal)foldable;
        }
        return new Literal(foldable.source(), foldable.fold(ctx), foldable.dataType());
    }

    public static Literal of(Expression source, Object value) {
        return new Literal(source.source(), value, source.dataType());
    }

    private static Object mapFromLiteralValue(StreamOutput out, DataType dataType, Object value) {
        if ((dataType == DataType.GEO_POINT || dataType == DataType.CARTESIAN_POINT) && out.getTransportVersion().before((VersionId)TransportVersions.V_8_13_0)) {
            if (value instanceof List) {
                List list = (List)value;
                return list.stream().map(v -> Literal.mapFromLiteralValue(out, dataType, v)).toList();
            }
            return Literal.wkbAsLong(dataType, (BytesRef)value);
        }
        return value;
    }

    private static Object mapToLiteralValue(StreamInput in, DataType dataType, Object value) {
        if ((dataType == DataType.GEO_POINT || dataType == DataType.CARTESIAN_POINT) && in.getTransportVersion().before((VersionId)TransportVersions.V_8_13_0)) {
            if (value instanceof List) {
                List list = (List)value;
                return list.stream().map(v -> Literal.mapToLiteralValue(in, dataType, v)).toList();
            }
            return Literal.longAsWKB(dataType, (Long)value);
        }
        return value;
    }

    private static BytesRef longAsWKB(DataType dataType, long encoded) {
        return dataType == DataType.GEO_POINT ? SpatialCoordinateTypes.GEO.longAsWkb(encoded) : SpatialCoordinateTypes.CARTESIAN.longAsWkb(encoded);
    }

    private static long wkbAsLong(DataType dataType, BytesRef wkb) {
        return dataType == DataType.GEO_POINT ? SpatialCoordinateTypes.GEO.wkbAsLong(wkb) : SpatialCoordinateTypes.CARTESIAN.wkbAsLong(wkb);
    }
}

