/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.db.DatabaseRecord;
import com.maxmind.db.Network;
import com.maxmind.db.Reader;
import com.maxmind.geoip2.model.AbstractResponse;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.ConnectionTypeResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.DomainResponse;
import com.maxmind.geoip2.model.EnterpriseResponse;
import com.maxmind.geoip2.model.IspResponse;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.Subdivision;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.ingest.geoip.Database;
import org.elasticsearch.ingest.geoip.IpDataLookup;
import org.elasticsearch.ingest.geoip.IpDatabase;

final class MaxmindIpDataLookups {
    private static final Logger logger = LogManager.getLogger(MaxmindIpDataLookups.class);
    static final String GEOIP2_PREFIX = "GeoIP2".toLowerCase(Locale.ROOT);
    static final String GEOLITE2_PREFIX = "GeoLite2".toLowerCase(Locale.ROOT);
    private static final String CITY_DB_SUFFIX = "-City";
    private static final String COUNTRY_DB_SUFFIX = "-Country";
    private static final String ASN_DB_SUFFIX = "-ASN";
    private static final String ANONYMOUS_IP_DB_SUFFIX = "-Anonymous-IP";
    private static final String CONNECTION_TYPE_DB_SUFFIX = "-Connection-Type";
    private static final String DOMAIN_DB_SUFFIX = "-Domain";
    private static final String ENTERPRISE_DB_SUFFIX = "-Enterprise";
    private static final String ISP_DB_SUFFIX = "-ISP";

    private MaxmindIpDataLookups() {
    }

    @Nullable
    static Database getMaxmindDatabase(String databaseType) {
        if (databaseType.endsWith(CITY_DB_SUFFIX)) {
            return Database.City;
        }
        if (databaseType.endsWith(COUNTRY_DB_SUFFIX)) {
            return Database.Country;
        }
        if (databaseType.endsWith(ASN_DB_SUFFIX)) {
            return Database.Asn;
        }
        if (databaseType.endsWith(ANONYMOUS_IP_DB_SUFFIX)) {
            return Database.AnonymousIp;
        }
        if (databaseType.endsWith(CONNECTION_TYPE_DB_SUFFIX)) {
            return Database.ConnectionType;
        }
        if (databaseType.endsWith(DOMAIN_DB_SUFFIX)) {
            return Database.Domain;
        }
        if (databaseType.endsWith(ENTERPRISE_DB_SUFFIX)) {
            return Database.Enterprise;
        }
        if (databaseType.endsWith(ISP_DB_SUFFIX)) {
            return Database.Isp;
        }
        logger.trace("returning null for unsupported database_type [{}]", (Object)databaseType);
        return null;
    }

    @Nullable
    static Function<Set<Database.Property>, IpDataLookup> getMaxmindLookup(Database database) {
        return switch (database) {
            case Database.City -> City::new;
            case Database.Country -> Country::new;
            case Database.Asn -> Asn::new;
            case Database.AnonymousIp -> AnonymousIp::new;
            case Database.ConnectionType -> ConnectionType::new;
            case Database.Domain -> Domain::new;
            case Database.Enterprise -> Enterprise::new;
            case Database.Isp -> Isp::new;
            default -> null;
        };
    }

    private static abstract class AbstractBase<RESPONSE extends AbstractResponse>
    implements IpDataLookup {
        protected final Set<Database.Property> properties;
        protected final Class<RESPONSE> clazz;
        protected final ResponseBuilder<RESPONSE> builder;

        AbstractBase(Set<Database.Property> properties, Class<RESPONSE> clazz, ResponseBuilder<RESPONSE> builder) {
            this.properties = Set.copyOf(properties);
            this.clazz = clazz;
            this.builder = builder;
        }

        @Override
        public Set<Database.Property> getProperties() {
            return this.properties;
        }

        @Override
        public final Map<String, Object> getData(IpDatabase ipDatabase, String ipAddress) {
            AbstractResponse response = (AbstractResponse)ipDatabase.getResponse(ipAddress, this::lookup);
            return response == null ? Map.of() : this.transform(response);
        }

        @Nullable
        private RESPONSE lookup(Reader reader, String ipAddress) throws IOException {
            InetAddress ip = InetAddresses.forString((String)ipAddress);
            DatabaseRecord record = reader.getRecord(ip, this.clazz);
            AbstractResponse data = (AbstractResponse)record.getData();
            return (RESPONSE)(data == null ? null : this.builder.build(data, NetworkAddress.format((InetAddress)ip), record.getNetwork(), List.of("en")));
        }

        protected abstract Map<String, Object> transform(RESPONSE var1);
    }

    @FunctionalInterface
    private static interface ResponseBuilder<RESPONSE extends AbstractResponse> {
        public RESPONSE build(RESPONSE var1, String var2, Network var3, List<String> var4);
    }

    static class Isp
    extends AbstractBase<IspResponse> {
        Isp(Set<Database.Property> properties) {
            super(properties, IspResponse.class, (response, ipAddress, network, locales) -> new IspResponse(response, ipAddress, network));
        }

        @Override
        protected Map<String, Object> transform(IspResponse response) {
            String isp = response.getIsp();
            String ispOrganization = response.getOrganization();
            String mobileNetworkCode = response.getMobileNetworkCode();
            String mobileCountryCode = response.getMobileCountryCode();
            Long asn = response.getAutonomousSystemNumber();
            String organizationName = response.getAutonomousSystemOrganization();
            Network network = response.getNetwork();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", response.getIpAddress());
                        break;
                    }
                    case ASN: {
                        if (asn == null) break;
                        data.put("asn", asn);
                        break;
                    }
                    case ORGANIZATION_NAME: {
                        if (organizationName == null) break;
                        data.put("organization_name", organizationName);
                        break;
                    }
                    case NETWORK: {
                        if (network == null) break;
                        data.put("network", network.toString());
                        break;
                    }
                    case ISP: {
                        if (isp == null) break;
                        data.put("isp", isp);
                        break;
                    }
                    case ISP_ORGANIZATION_NAME: {
                        if (ispOrganization == null) break;
                        data.put("isp_organization_name", ispOrganization);
                        break;
                    }
                    case MOBILE_COUNTRY_CODE: {
                        if (mobileCountryCode == null) break;
                        data.put("mobile_country_code", mobileCountryCode);
                        break;
                    }
                    case MOBILE_NETWORK_CODE: {
                        if (mobileNetworkCode == null) break;
                        data.put("mobile_network_code", mobileNetworkCode);
                    }
                }
            }
            return data;
        }
    }

    static class Enterprise
    extends AbstractBase<EnterpriseResponse> {
        Enterprise(Set<Database.Property> properties) {
            super(properties, EnterpriseResponse.class, EnterpriseResponse::new);
        }

        @Override
        protected Map<String, Object> transform(EnterpriseResponse response) {
            com.maxmind.geoip2.record.Country country = response.getCountry();
            com.maxmind.geoip2.record.Country registeredCountry = response.getRegisteredCountry();
            com.maxmind.geoip2.record.City city = response.getCity();
            Location location = response.getLocation();
            Continent continent = response.getContinent();
            Subdivision subdivision = response.getMostSpecificSubdivision();
            Postal postal = response.getPostal();
            Long asn = response.getTraits().getAutonomousSystemNumber();
            String organizationName = response.getTraits().getAutonomousSystemOrganization();
            Network network = response.getTraits().getNetwork();
            String isp = response.getTraits().getIsp();
            String ispOrganization = response.getTraits().getOrganization();
            String mobileCountryCode = response.getTraits().getMobileCountryCode();
            String mobileNetworkCode = response.getTraits().getMobileNetworkCode();
            boolean isHostingProvider = response.getTraits().isHostingProvider();
            boolean isTorExitNode = response.getTraits().isTorExitNode();
            boolean isAnonymousVpn = response.getTraits().isAnonymousVpn();
            boolean isAnonymous = response.getTraits().isAnonymous();
            boolean isPublicProxy = response.getTraits().isPublicProxy();
            boolean isResidentialProxy = response.getTraits().isResidentialProxy();
            String userType = response.getTraits().getUserType();
            String domain = response.getTraits().getDomain();
            ConnectionTypeResponse.ConnectionType connectionType = response.getTraits().getConnectionType();
            HashMap<String, Object> data = new HashMap<String, Object>();
            block37: for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", response.getTraits().getIpAddress());
                        break;
                    }
                    case COUNTRY_CONFIDENCE: {
                        Integer countryConfidence = country.getConfidence();
                        if (countryConfidence == null) continue block37;
                        data.put("country_confidence", countryConfidence);
                        break;
                    }
                    case COUNTRY_IN_EUROPEAN_UNION: {
                        if (country.getIsoCode() == null) break;
                        data.put("country_in_european_union", country.isInEuropeanUnion());
                        break;
                    }
                    case COUNTRY_ISO_CODE: {
                        String countryIsoCode = country.getIsoCode();
                        if (countryIsoCode == null) continue block37;
                        data.put("country_iso_code", countryIsoCode);
                        break;
                    }
                    case COUNTRY_NAME: {
                        String countryName = country.getName();
                        if (countryName == null) continue block37;
                        data.put("country_name", countryName);
                        break;
                    }
                    case CONTINENT_CODE: {
                        String continentCode = continent.getCode();
                        if (continentCode == null) continue block37;
                        data.put("continent_code", continentCode);
                        break;
                    }
                    case CONTINENT_NAME: {
                        String continentName = continent.getName();
                        if (continentName == null) continue block37;
                        data.put("continent_name", continentName);
                        break;
                    }
                    case REGION_ISO_CODE: {
                        String countryIso = country.getIsoCode();
                        String subdivisionIso = subdivision.getIsoCode();
                        if (countryIso == null || subdivisionIso == null) continue block37;
                        String regionIsoCode = countryIso + "-" + subdivisionIso;
                        data.put("region_iso_code", regionIsoCode);
                        break;
                    }
                    case REGION_NAME: {
                        String subdivisionName = subdivision.getName();
                        if (subdivisionName == null) continue block37;
                        data.put("region_name", subdivisionName);
                        break;
                    }
                    case CITY_CONFIDENCE: {
                        Integer cityConfidence = city.getConfidence();
                        if (cityConfidence == null) continue block37;
                        data.put("city_confidence", cityConfidence);
                        break;
                    }
                    case CITY_NAME: {
                        String cityName = city.getName();
                        if (cityName == null) continue block37;
                        data.put("city_name", cityName);
                        break;
                    }
                    case TIMEZONE: {
                        String locationTimeZone = location.getTimeZone();
                        if (locationTimeZone == null) continue block37;
                        data.put("timezone", locationTimeZone);
                        break;
                    }
                    case LOCATION: {
                        Double latitude = location.getLatitude();
                        Double longitude = location.getLongitude();
                        if (latitude == null || longitude == null) continue block37;
                        HashMap<String, Double> locationObject = new HashMap<String, Double>();
                        locationObject.put("lat", latitude);
                        locationObject.put("lon", longitude);
                        data.put("location", locationObject);
                        break;
                    }
                    case ACCURACY_RADIUS: {
                        Integer accuracyRadius = location.getAccuracyRadius();
                        if (accuracyRadius == null) continue block37;
                        data.put("accuracy_radius", accuracyRadius);
                        break;
                    }
                    case POSTAL_CODE: {
                        if (postal == null || postal.getCode() == null) break;
                        data.put("postal_code", postal.getCode());
                        break;
                    }
                    case POSTAL_CONFIDENCE: {
                        Integer postalConfidence = postal.getConfidence();
                        if (postalConfidence == null) continue block37;
                        data.put("postal_confidence", postalConfidence);
                        break;
                    }
                    case ASN: {
                        if (asn == null) break;
                        data.put("asn", asn);
                        break;
                    }
                    case ORGANIZATION_NAME: {
                        if (organizationName == null) break;
                        data.put("organization_name", organizationName);
                        break;
                    }
                    case NETWORK: {
                        if (network == null) break;
                        data.put("network", network.toString());
                        break;
                    }
                    case HOSTING_PROVIDER: {
                        data.put("hosting_provider", isHostingProvider);
                        break;
                    }
                    case TOR_EXIT_NODE: {
                        data.put("tor_exit_node", isTorExitNode);
                        break;
                    }
                    case ANONYMOUS_VPN: {
                        data.put("anonymous_vpn", isAnonymousVpn);
                        break;
                    }
                    case ANONYMOUS: {
                        data.put("anonymous", isAnonymous);
                        break;
                    }
                    case PUBLIC_PROXY: {
                        data.put("public_proxy", isPublicProxy);
                        break;
                    }
                    case RESIDENTIAL_PROXY: {
                        data.put("residential_proxy", isResidentialProxy);
                        break;
                    }
                    case DOMAIN: {
                        if (domain == null) break;
                        data.put("domain", domain);
                        break;
                    }
                    case ISP: {
                        if (isp == null) break;
                        data.put("isp", isp);
                        break;
                    }
                    case ISP_ORGANIZATION_NAME: {
                        if (ispOrganization == null) break;
                        data.put("isp_organization_name", ispOrganization);
                        break;
                    }
                    case MOBILE_COUNTRY_CODE: {
                        if (mobileCountryCode == null) break;
                        data.put("mobile_country_code", mobileCountryCode);
                        break;
                    }
                    case MOBILE_NETWORK_CODE: {
                        if (mobileNetworkCode == null) break;
                        data.put("mobile_network_code", mobileNetworkCode);
                        break;
                    }
                    case USER_TYPE: {
                        if (userType == null) break;
                        data.put("user_type", userType);
                        break;
                    }
                    case CONNECTION_TYPE: {
                        if (connectionType == null) break;
                        data.put("connection_type", connectionType.toString());
                        break;
                    }
                    case REGISTERED_COUNTRY_IN_EUROPEAN_UNION: {
                        if (registeredCountry.getIsoCode() == null) break;
                        data.put("registered_country_in_european_union", registeredCountry.isInEuropeanUnion());
                        break;
                    }
                    case REGISTERED_COUNTRY_ISO_CODE: {
                        if (registeredCountry.getIsoCode() == null) break;
                        data.put("registered_country_iso_code", registeredCountry.getIsoCode());
                        break;
                    }
                    case REGISTERED_COUNTRY_NAME: {
                        if (registeredCountry.getName() == null) break;
                        data.put("registered_country_name", registeredCountry.getName());
                    }
                }
            }
            return data;
        }
    }

    static class Domain
    extends AbstractBase<DomainResponse> {
        Domain(Set<Database.Property> properties) {
            super(properties, DomainResponse.class, (response, ipAddress, network, locales) -> new DomainResponse(response, ipAddress, network));
        }

        @Override
        protected Map<String, Object> transform(DomainResponse response) {
            String domain = response.getDomain();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", response.getIpAddress());
                        break;
                    }
                    case DOMAIN: {
                        if (domain == null) break;
                        data.put("domain", domain);
                    }
                }
            }
            return data;
        }
    }

    static class Country
    extends AbstractBase<CountryResponse> {
        Country(Set<Database.Property> properties) {
            super(properties, CountryResponse.class, CountryResponse::new);
        }

        @Override
        protected Map<String, Object> transform(CountryResponse response) {
            com.maxmind.geoip2.record.Country country = response.getCountry();
            com.maxmind.geoip2.record.Country registeredCountry = response.getRegisteredCountry();
            Continent continent = response.getContinent();
            HashMap<String, Object> data = new HashMap<String, Object>();
            block11: for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", response.getTraits().getIpAddress());
                        break;
                    }
                    case COUNTRY_IN_EUROPEAN_UNION: {
                        if (country.getIsoCode() == null) break;
                        data.put("country_in_european_union", country.isInEuropeanUnion());
                        break;
                    }
                    case COUNTRY_ISO_CODE: {
                        String countryIsoCode = country.getIsoCode();
                        if (countryIsoCode == null) continue block11;
                        data.put("country_iso_code", countryIsoCode);
                        break;
                    }
                    case COUNTRY_NAME: {
                        String countryName = country.getName();
                        if (countryName == null) continue block11;
                        data.put("country_name", countryName);
                        break;
                    }
                    case CONTINENT_CODE: {
                        String continentCode = continent.getCode();
                        if (continentCode == null) continue block11;
                        data.put("continent_code", continentCode);
                        break;
                    }
                    case CONTINENT_NAME: {
                        String continentName = continent.getName();
                        if (continentName == null) continue block11;
                        data.put("continent_name", continentName);
                        break;
                    }
                    case REGISTERED_COUNTRY_IN_EUROPEAN_UNION: {
                        if (registeredCountry.getIsoCode() == null) break;
                        data.put("registered_country_in_european_union", registeredCountry.isInEuropeanUnion());
                        break;
                    }
                    case REGISTERED_COUNTRY_ISO_CODE: {
                        if (registeredCountry.getIsoCode() == null) break;
                        data.put("registered_country_iso_code", registeredCountry.getIsoCode());
                        break;
                    }
                    case REGISTERED_COUNTRY_NAME: {
                        if (registeredCountry.getName() == null) break;
                        data.put("registered_country_name", registeredCountry.getName());
                    }
                }
            }
            return data;
        }
    }

    static class ConnectionType
    extends AbstractBase<ConnectionTypeResponse> {
        ConnectionType(Set<Database.Property> properties) {
            super(properties, ConnectionTypeResponse.class, (response, ipAddress, network, locales) -> new ConnectionTypeResponse(response, ipAddress, network));
        }

        @Override
        protected Map<String, Object> transform(ConnectionTypeResponse response) {
            ConnectionTypeResponse.ConnectionType connectionType = response.getConnectionType();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", response.getIpAddress());
                        break;
                    }
                    case CONNECTION_TYPE: {
                        if (connectionType == null) break;
                        data.put("connection_type", connectionType.toString());
                    }
                }
            }
            return data;
        }
    }

    static class City
    extends AbstractBase<CityResponse> {
        City(Set<Database.Property> properties) {
            super(properties, CityResponse.class, CityResponse::new);
        }

        @Override
        protected Map<String, Object> transform(CityResponse response) {
            com.maxmind.geoip2.record.Country country = response.getCountry();
            com.maxmind.geoip2.record.Country registeredCountry = response.getRegisteredCountry();
            com.maxmind.geoip2.record.City city = response.getCity();
            Location location = response.getLocation();
            Continent continent = response.getContinent();
            Subdivision subdivision = response.getMostSpecificSubdivision();
            Postal postal = response.getPostal();
            HashMap<String, Object> data = new HashMap<String, Object>();
            block18: for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", response.getTraits().getIpAddress());
                        break;
                    }
                    case COUNTRY_IN_EUROPEAN_UNION: {
                        if (country.getIsoCode() == null) break;
                        data.put("country_in_european_union", country.isInEuropeanUnion());
                        break;
                    }
                    case COUNTRY_ISO_CODE: {
                        String countryIsoCode = country.getIsoCode();
                        if (countryIsoCode == null) continue block18;
                        data.put("country_iso_code", countryIsoCode);
                        break;
                    }
                    case COUNTRY_NAME: {
                        String countryName = country.getName();
                        if (countryName == null) continue block18;
                        data.put("country_name", countryName);
                        break;
                    }
                    case CONTINENT_CODE: {
                        String continentCode = continent.getCode();
                        if (continentCode == null) continue block18;
                        data.put("continent_code", continentCode);
                        break;
                    }
                    case CONTINENT_NAME: {
                        String continentName = continent.getName();
                        if (continentName == null) continue block18;
                        data.put("continent_name", continentName);
                        break;
                    }
                    case REGION_ISO_CODE: {
                        String countryIso = country.getIsoCode();
                        String subdivisionIso = subdivision.getIsoCode();
                        if (countryIso == null || subdivisionIso == null) continue block18;
                        String regionIsoCode = countryIso + "-" + subdivisionIso;
                        data.put("region_iso_code", regionIsoCode);
                        break;
                    }
                    case REGION_NAME: {
                        String subdivisionName = subdivision.getName();
                        if (subdivisionName == null) continue block18;
                        data.put("region_name", subdivisionName);
                        break;
                    }
                    case CITY_NAME: {
                        String cityName = city.getName();
                        if (cityName == null) continue block18;
                        data.put("city_name", cityName);
                        break;
                    }
                    case TIMEZONE: {
                        String locationTimeZone = location.getTimeZone();
                        if (locationTimeZone == null) continue block18;
                        data.put("timezone", locationTimeZone);
                        break;
                    }
                    case LOCATION: {
                        Double latitude = location.getLatitude();
                        Double longitude = location.getLongitude();
                        if (latitude == null || longitude == null) continue block18;
                        HashMap<String, Double> locationObject = new HashMap<String, Double>();
                        locationObject.put("lat", latitude);
                        locationObject.put("lon", longitude);
                        data.put("location", locationObject);
                        break;
                    }
                    case ACCURACY_RADIUS: {
                        Integer accuracyRadius = location.getAccuracyRadius();
                        if (accuracyRadius == null) continue block18;
                        data.put("accuracy_radius", accuracyRadius);
                        break;
                    }
                    case POSTAL_CODE: {
                        if (postal == null || postal.getCode() == null) break;
                        data.put("postal_code", postal.getCode());
                        break;
                    }
                    case REGISTERED_COUNTRY_IN_EUROPEAN_UNION: {
                        if (registeredCountry.getIsoCode() == null) break;
                        data.put("registered_country_in_european_union", registeredCountry.isInEuropeanUnion());
                        break;
                    }
                    case REGISTERED_COUNTRY_ISO_CODE: {
                        if (registeredCountry.getIsoCode() == null) break;
                        data.put("registered_country_iso_code", registeredCountry.getIsoCode());
                        break;
                    }
                    case REGISTERED_COUNTRY_NAME: {
                        if (registeredCountry.getName() == null) break;
                        data.put("registered_country_name", registeredCountry.getName());
                    }
                }
            }
            return data;
        }
    }

    static class Asn
    extends AbstractBase<AsnResponse> {
        Asn(Set<Database.Property> properties) {
            super(properties, AsnResponse.class, (response, ipAddress, network, locales) -> new AsnResponse(response, ipAddress, network));
        }

        @Override
        protected Map<String, Object> transform(AsnResponse response) {
            Long asn = response.getAutonomousSystemNumber();
            String organizationName = response.getAutonomousSystemOrganization();
            Network network = response.getNetwork();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", response.getIpAddress());
                        break;
                    }
                    case ASN: {
                        if (asn == null) break;
                        data.put("asn", asn);
                        break;
                    }
                    case ORGANIZATION_NAME: {
                        if (organizationName == null) break;
                        data.put("organization_name", organizationName);
                        break;
                    }
                    case NETWORK: {
                        if (network == null) break;
                        data.put("network", network.toString());
                    }
                }
            }
            return data;
        }
    }

    static class AnonymousIp
    extends AbstractBase<AnonymousIpResponse> {
        AnonymousIp(Set<Database.Property> properties) {
            super(properties, AnonymousIpResponse.class, (response, ipAddress, network, locales) -> new AnonymousIpResponse(response, ipAddress, network));
        }

        @Override
        protected Map<String, Object> transform(AnonymousIpResponse response) {
            boolean isHostingProvider = response.isHostingProvider();
            boolean isTorExitNode = response.isTorExitNode();
            boolean isAnonymousVpn = response.isAnonymousVpn();
            boolean isAnonymous = response.isAnonymous();
            boolean isPublicProxy = response.isPublicProxy();
            boolean isResidentialProxy = response.isResidentialProxy();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", response.getIpAddress());
                        break;
                    }
                    case HOSTING_PROVIDER: {
                        data.put("hosting_provider", isHostingProvider);
                        break;
                    }
                    case TOR_EXIT_NODE: {
                        data.put("tor_exit_node", isTorExitNode);
                        break;
                    }
                    case ANONYMOUS_VPN: {
                        data.put("anonymous_vpn", isAnonymousVpn);
                        break;
                    }
                    case ANONYMOUS: {
                        data.put("anonymous", isAnonymous);
                        break;
                    }
                    case PUBLIC_PROXY: {
                        data.put("public_proxy", isPublicProxy);
                        break;
                    }
                    case RESIDENTIAL_PROXY: {
                        data.put("residential_proxy", isResidentialProxy);
                    }
                }
            }
            return data;
        }
    }
}

