/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.ingest.geoip.GeoIpDownloader;
import org.elasticsearch.ingest.geoip.GeoIpProcessor;
import org.elasticsearch.ingest.geoip.GeoIpTaskParams;
import org.elasticsearch.ingest.geoip.GeoIpTaskState;
import org.elasticsearch.ingest.geoip.HttpClient;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteTransportException;

public final class GeoIpDownloaderTaskExecutor
extends PersistentTasksExecutor<GeoIpTaskParams>
implements ClusterStateListener {
    private static final boolean ENABLED_DEFAULT = !"false".equals(System.getProperty("ingest.geoip.downloader.enabled.default", "true"));
    public static final Setting<Boolean> ENABLED_SETTING = Setting.boolSetting((String)"ingest.geoip.downloader.enabled", (boolean)ENABLED_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> POLL_INTERVAL_SETTING = Setting.timeSetting((String)"ingest.geoip.downloader.poll.interval", (TimeValue)TimeValue.timeValueDays((long)3L), (TimeValue)TimeValue.timeValueDays((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> EAGER_DOWNLOAD_SETTING = Setting.boolSetting((String)"ingest.geoip.downloader.eager.download", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(GeoIpDownloader.class);
    private final Client client;
    private final HttpClient httpClient;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final PersistentTasksService persistentTasksService;
    private final AtomicReference<GeoIpDownloader> currentTask = new AtomicReference();
    private volatile TimeValue pollInterval;
    private volatile boolean eagerDownload;
    private volatile boolean atLeastOneGeoipProcessor;
    private final AtomicBoolean taskIsBootstrapped = new AtomicBoolean(false);

    GeoIpDownloaderTaskExecutor(Client client, HttpClient httpClient, ClusterService clusterService, ThreadPool threadPool) {
        super("geoip-downloader", (Executor)threadPool.generic());
        this.client = new OriginSettingClient(client, "ingest");
        this.httpClient = httpClient;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.settings = clusterService.getSettings();
        this.persistentTasksService = new PersistentTasksService(clusterService, threadPool, client);
        this.pollInterval = (TimeValue)POLL_INTERVAL_SETTING.get(this.settings);
        this.eagerDownload = (Boolean)EAGER_DOWNLOAD_SETTING.get(this.settings);
    }

    public void init() {
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ENABLED_SETTING, this::setEnabled);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(EAGER_DOWNLOAD_SETTING, this::setEagerDownload);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(POLL_INTERVAL_SETTING, this::setPollInterval);
    }

    private void setEnabled(boolean enabled) {
        if (!this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            return;
        }
        if (enabled) {
            this.startTask(() -> {});
        } else {
            this.stopTask(() -> {});
        }
    }

    private void setEagerDownload(Boolean eagerDownload) {
        if (!Objects.equals(this.eagerDownload, eagerDownload)) {
            this.eagerDownload = eagerDownload;
            GeoIpDownloader currentDownloader = this.getCurrentTask();
            if (currentDownloader != null && Objects.equals(eagerDownload, Boolean.TRUE)) {
                currentDownloader.requestReschedule();
            }
        }
    }

    private void setPollInterval(TimeValue pollInterval) {
        if (!Objects.equals(this.pollInterval, pollInterval)) {
            this.pollInterval = pollInterval;
            GeoIpDownloader currentDownloader = this.getCurrentTask();
            if (currentDownloader != null) {
                currentDownloader.requestReschedule();
            }
        }
    }

    protected void nodeOperation(AllocatedPersistentTask task, GeoIpTaskParams params, PersistentTaskState state) {
        GeoIpDownloader downloader = (GeoIpDownloader)task;
        GeoIpTaskState geoIpTaskState = state == null ? GeoIpTaskState.EMPTY : (GeoIpTaskState)state;
        downloader.setState(geoIpTaskState);
        this.currentTask.set(downloader);
        if (((Boolean)ENABLED_SETTING.get(this.clusterService.state().metadata().settings(), this.settings)).booleanValue()) {
            downloader.runDownloader();
        }
    }

    protected GeoIpDownloader createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<GeoIpTaskParams> taskInProgress, Map<String, String> headers) {
        return new GeoIpDownloader(this.client, this.httpClient, this.clusterService, this.threadPool, this.settings, id, type, action, this.getDescription(taskInProgress), parentTaskId, headers, () -> this.pollInterval, () -> this.eagerDownload, () -> this.atLeastOneGeoipProcessor);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean hasIngestPipelineChanges;
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNode masterNode = event.state().nodes().getMasterNode();
        if (masterNode == null) {
            return;
        }
        if (!this.taskIsBootstrapped.getAndSet(true)) {
            this.atLeastOneGeoipProcessor = GeoIpDownloaderTaskExecutor.hasAtLeastOneGeoipProcessor(event.state());
            if (((Boolean)ENABLED_SETTING.get(event.state().getMetadata().settings(), this.settings)).booleanValue()) {
                this.startTask(() -> this.taskIsBootstrapped.set(false));
            } else {
                this.stopTask(() -> this.taskIsBootstrapped.set(false));
            }
        }
        if (!event.metadataChanged()) {
            return;
        }
        boolean hasIndicesChanges = !event.previousState().metadata().indices().equals(event.state().metadata().indices());
        boolean bl = hasIngestPipelineChanges = event.metadataChanged() && event.changedCustomMetadataSet().contains("ingest");
        if (hasIngestPipelineChanges || hasIndicesChanges) {
            boolean newAtLeastOneGeoipProcessor = GeoIpDownloaderTaskExecutor.hasAtLeastOneGeoipProcessor(event.state());
            if (newAtLeastOneGeoipProcessor && !this.atLeastOneGeoipProcessor) {
                this.atLeastOneGeoipProcessor = true;
                logger.trace("Scheduling runDownloader because a geoip processor has been added");
                GeoIpDownloader currentDownloader = this.getCurrentTask();
                if (currentDownloader != null) {
                    currentDownloader.requestReschedule();
                }
            } else {
                this.atLeastOneGeoipProcessor = newAtLeastOneGeoipProcessor;
            }
        }
    }

    static boolean hasAtLeastOneGeoipProcessor(ClusterState clusterState) {
        if (!GeoIpDownloaderTaskExecutor.pipelinesWithGeoIpProcessor(clusterState, true).isEmpty()) {
            return true;
        }
        Set<String> checkReferencedPipelines = GeoIpDownloaderTaskExecutor.pipelinesWithGeoIpProcessor(clusterState, false);
        if (checkReferencedPipelines.isEmpty()) {
            return false;
        }
        return clusterState.getMetadata().indices().values().stream().anyMatch(indexMetadata -> {
            String defaultPipeline = (String)IndexSettings.DEFAULT_PIPELINE.get(indexMetadata.getSettings());
            String finalPipeline = (String)IndexSettings.FINAL_PIPELINE.get(indexMetadata.getSettings());
            return checkReferencedPipelines.contains(defaultPipeline) || checkReferencedPipelines.contains(finalPipeline);
        });
    }

    private static Set<String> pipelinesWithGeoIpProcessor(ClusterState clusterState, boolean downloadDatabaseOnPipelineCreation) {
        List configurations = IngestService.getPipelines((ClusterState)clusterState, (String[])new String[0]);
        HashSet<String> ids = new HashSet<String>();
        for (PipelineConfiguration configuration : configurations) {
            List processors = (List)configuration.getConfig().get("processors");
            if (!GeoIpDownloaderTaskExecutor.hasAtLeastOneGeoipProcessor(processors, downloadDatabaseOnPipelineCreation)) continue;
            ids.add(configuration.getId());
        }
        return Collections.unmodifiableSet(ids);
    }

    private static boolean hasAtLeastOneGeoipProcessor(List<Map<String, Object>> processors, boolean downloadDatabaseOnPipelineCreation) {
        if (processors != null) {
            for (Map<String, Object> processor : processors) {
                if (!GeoIpDownloaderTaskExecutor.hasAtLeastOneGeoipProcessor(processor, downloadDatabaseOnPipelineCreation)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasAtLeastOneGeoipProcessor(Map<String, Object> processor, boolean downloadDatabaseOnPipelineCreation) {
        if (processor == null) {
            return false;
        }
        Map processorConfig = (Map)processor.get("geoip");
        if (processorConfig != null) {
            return GeoIpProcessor.Factory.downloadDatabaseOnPipelineCreation(processorConfig) == downloadDatabaseOnPipelineCreation;
        }
        processorConfig = (Map)processor.get("ip_location");
        if (processorConfig != null) {
            return GeoIpProcessor.Factory.downloadDatabaseOnPipelineCreation(processorConfig) == downloadDatabaseOnPipelineCreation;
        }
        return GeoIpDownloaderTaskExecutor.isProcessorWithOnFailureGeoIpProcessor(processor, downloadDatabaseOnPipelineCreation) || GeoIpDownloaderTaskExecutor.isForeachProcessorWithGeoipProcessor(processor, downloadDatabaseOnPipelineCreation);
    }

    private static boolean isProcessorWithOnFailureGeoIpProcessor(Map<String, Object> processor, boolean downloadDatabaseOnPipelineCreation) {
        for (Object value : processor.values()) {
            if (!(value instanceof Map) || !GeoIpDownloaderTaskExecutor.hasAtLeastOneGeoipProcessor((List)((Map)value).get("on_failure"), downloadDatabaseOnPipelineCreation)) continue;
            return true;
        }
        return false;
    }

    private static boolean isForeachProcessorWithGeoipProcessor(Map<String, Object> processor, boolean downloadDatabaseOnPipelineCreation) {
        Map processorConfig = (Map)processor.get("foreach");
        return processorConfig != null && GeoIpDownloaderTaskExecutor.hasAtLeastOneGeoipProcessor((Map)processorConfig.get("processor"), downloadDatabaseOnPipelineCreation);
    }

    private void startTask(Runnable onFailure) {
        this.persistentTasksService.sendStartRequest("geoip-downloader", "geoip-downloader", (PersistentTaskParams)new GeoIpTaskParams(), MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, ActionListener.wrap(r -> logger.debug("Started geoip downloader task"), e -> {
            Throwable t;
            Throwable throwable = t = e instanceof RemoteTransportException ? ExceptionsHelper.unwrapCause((Throwable)e) : e;
            if (!(t instanceof ResourceAlreadyExistsException)) {
                logger.error("failed to create geoip downloader task", (Throwable)e);
                onFailure.run();
            }
        }));
    }

    private void stopTask(Runnable onFailure) {
        ActionListener listener = ActionListener.wrap(r -> logger.debug("Stopped geoip downloader task"), e -> {
            Throwable t;
            Throwable throwable = t = e instanceof RemoteTransportException ? ExceptionsHelper.unwrapCause((Throwable)e) : e;
            if (!(t instanceof ResourceNotFoundException)) {
                logger.error("failed to remove geoip downloader task", (Throwable)e);
                onFailure.run();
            }
        });
        this.persistentTasksService.sendRemoveRequest("geoip-downloader", MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, ActionListener.runAfter((ActionListener)listener, () -> {
            IndexAbstraction databasesAbstraction = (IndexAbstraction)this.clusterService.state().metadata().getIndicesLookup().get(".geoip_databases");
            if (databasesAbstraction != null) {
                Index databasesIndex = databasesAbstraction.getWriteIndex();
                this.client.admin().indices().prepareDelete(new String[]{databasesIndex.getName()}).execute(ActionListener.wrap(rr -> {}, e -> {
                    Throwable t;
                    Throwable throwable = t = e instanceof RemoteTransportException ? ExceptionsHelper.unwrapCause((Throwable)e) : e;
                    if (!(t instanceof ResourceNotFoundException)) {
                        logger.warn("failed to remove " + String.valueOf(databasesIndex), (Throwable)e);
                    }
                }));
            }
        }));
    }

    public GeoIpDownloader getCurrentTask() {
        return this.currentTask.get();
    }
}

