/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

class ProcessUtil {
    private ProcessUtil() {
    }

    static <T> T nonInterruptible(Interruptible<T> interruptible) {
        try {
            return interruptible.run();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError((Object)e);
        }
    }

    static void nonInterruptibleVoid(InterruptibleVoid interruptible) {
        ProcessUtil.nonInterruptible(() -> {
            interruptible.run();
            return null;
        });
    }

    static interface Interruptible<T> {
        public T run() throws InterruptedException;
    }

    static interface InterruptibleVoid {
        public void run() throws InterruptedException;
    }
}

