/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support.mapper;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheAction;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheRequest;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;

public abstract class AbstractRoleMapperClearRealmCache
implements UserRoleMapper {
    private static final Logger logger = LogManager.getLogger(AbstractRoleMapperClearRealmCache.class);
    private final List<String> realmNamesToClearCaches = new CopyOnWriteArrayList<String>();
    private final List<Runnable> localRealmCacheInvalidators = new CopyOnWriteArrayList<Runnable>();

    public void clearRealmCacheOnChange(CachingRealm realm) {
        this.realmNamesToClearCaches.add(realm.name());
        this.localRealmCacheInvalidators.add(() -> ((CachingRealm)realm).expireAll());
    }

    protected void clearRealmCachesOnAllNodes(Client client, ActionListener<Void> listener) {
        if (this.realmNamesToClearCaches.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        String[] realmNames = this.realmNamesToClearCaches.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY);
        ClientHelper.executeAsyncWithOrigin((Client)client, (String)"security", (ActionType)ClearRealmCacheAction.INSTANCE, (ActionRequest)new ClearRealmCacheRequest().realms(realmNames), (ActionListener)ActionListener.wrap(response -> {
            logger.debug(() -> Strings.format((String)"Cleared cached in realms [%s] due to role mapping change", (Object[])new Object[]{Arrays.toString(realmNames)}));
            listener.onResponse(null);
        }, ex -> {
            logger.warn(() -> "Failed to clear cache for realms [" + Arrays.toString(realmNames) + "]", (Throwable)ex);
            listener.onFailure(ex);
        }));
    }

    public void clearRealmCachesOnLocalNode() {
        this.localRealmCacheInvalidators.forEach(Runnable::run);
    }
}

