/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.support.DLSRoleQueryValidator;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public class ApiKeyUserRoleDescriptorResolver {
    private final CompositeRolesStore rolesStore;
    private final NamedXContentRegistry xContentRegistry;

    public ApiKeyUserRoleDescriptorResolver(CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        this.rolesStore = rolesStore;
        this.xContentRegistry = xContentRegistry;
    }

    public void resolveUserRoleDescriptors(Authentication authentication, ActionListener<Set<RoleDescriptor>> listener) {
        Subject effectiveSubject = authentication.getEffectiveSubject();
        if (effectiveSubject.getType() == Subject.Type.API_KEY) {
            listener.onResponse(Set.of());
            return;
        }
        this.rolesStore.getRoleDescriptors(effectiveSubject, (ActionListener<Set<RoleDescriptor>>)listener.delegateFailureAndWrap(this::handleRoleDescriptors));
    }

    private void handleRoleDescriptors(ActionListener<Set<RoleDescriptor>> listener, Set<RoleDescriptor> roleDescriptors) {
        for (RoleDescriptor rd : roleDescriptors) {
            DLSRoleQueryValidator.validateQueryField((RoleDescriptor.IndicesPrivileges[])rd.getIndicesPrivileges(), (NamedXContentRegistry)this.xContentRegistry);
        }
        listener.onResponse(roleDescriptors);
    }
}

