/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.ldap.ActiveDirectorySessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.SearchGroupsResolverSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.core.security.authc.ldap.support.SessionFactorySettings;
import org.elasticsearch.xpack.security.authc.ldap.ActiveDirectorySIDUtil;
import org.elasticsearch.xpack.security.authc.ldap.ActiveDirectorySessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;

class ActiveDirectoryGroupsResolver
implements LdapSession.GroupsResolver {
    private final String baseDn;
    private final LdapSearchScope scope;
    private final boolean ignoreReferralErrors;

    ActiveDirectoryGroupsResolver(RealmConfig config) {
        this.baseDn = (String)config.getSetting(SearchGroupsResolverSettings.BASE_DN, () -> ActiveDirectorySessionFactory.buildDnFromDomain((String)config.getSetting(ActiveDirectorySessionFactorySettings.AD_DOMAIN_NAME_SETTING)));
        this.scope = (LdapSearchScope)config.getSetting(SearchGroupsResolverSettings.SCOPE);
        this.ignoreReferralErrors = (Boolean)config.getSetting(SessionFactorySettings.IGNORE_REFERRAL_ERRORS_SETTING);
    }

    @Override
    public void resolve(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger, Collection<Attribute> attributes, ActionListener<List<String>> listener) {
        ActiveDirectoryGroupsResolver.buildGroupQuery(connection, userDn, timeout, this.ignoreReferralErrors, (ActionListener<Filter>)ActionListener.wrap(filter -> {
            if (filter == null) {
                listener.onResponse(List.of());
            } else {
                logger.debug("group SID to DN [{}] search filter: [{}]", (Object)userDn, filter);
                LdapUtils.search(connection, this.baseDn, this.scope.scope(), filter, Math.toIntExact(timeout.seconds()), this.ignoreReferralErrors, (ActionListener<List<SearchResultEntry>>)ActionListener.wrap(results -> {
                    List<String> groups = results.stream().map(Entry::getDN).toList();
                    listener.onResponse(groups);
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), "1.1");
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public String[] attributes() {
        return null;
    }

    static void buildGroupQuery(LDAPInterface connection, String userDn, TimeValue timeout, boolean ignoreReferralErrors, ActionListener<Filter> listener) {
        LdapUtils.searchForEntry(connection, userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, Math.toIntExact(timeout.seconds()), ignoreReferralErrors, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
            if (entry == null || !entry.hasAttribute("tokenGroups")) {
                listener.onResponse(null);
            } else {
                byte[][] tokenGroupSIDBytes = entry.getAttributeValueByteArrays("tokenGroups");
                List<Filter> orFilters = Arrays.stream(tokenGroupSIDBytes).map(sidBytes -> Filter.createEqualityFilter((String)"objectSid", (String)ActiveDirectorySIDUtil.convertToString(sidBytes))).toList();
                listener.onResponse((Object)Filter.createORFilter(orFilters));
            }
        }, arg_0 -> listener.onFailure(arg_0)), "tokenGroups");
    }
}

