/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit.logfile;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.filter.MarkerFilter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonStringEncoder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.action.ActionTypes;
import org.elasticsearch.xpack.core.security.action.Grant;
import org.elasticsearch.xpack.core.security.action.apikey.AbstractCreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.BaseSingleUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.BaseUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.BulkUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CreateCrossClusterApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.GrantApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.InvalidateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateCrossClusterApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.privilege.DeletePrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.privilege.PutPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.profile.ActivateProfileRequest;
import org.elasticsearch.xpack.core.security.action.profile.SetProfileEnabledRequest;
import org.elasticsearch.xpack.core.security.action.profile.UpdateProfileDataRequest;
import org.elasticsearch.xpack.core.security.action.role.BulkDeleteRolesRequest;
import org.elasticsearch.xpack.core.security.action.role.BulkPutRolesRequest;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.PutRoleRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingRequest;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenRequest;
import org.elasticsearch.xpack.core.security.action.service.DeleteServiceAccountTokenRequest;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordRequest;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserRequest;
import org.elasticsearch.xpack.core.security.action.user.PutUserRequest;
import org.elasticsearch.xpack.core.security.action.user.SetEnabledRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivileges;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.user.InternalUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.action.user.TransportChangePasswordAction;
import org.elasticsearch.xpack.security.action.user.TransportSetEnabledAction;
import org.elasticsearch.xpack.security.audit.AuditLevel;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountToken;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.transport.filter.SecurityIpFilterRule;

public class LoggingAuditTrail
implements AuditTrail,
ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(LoggingAuditTrail.class);
    public static final String REST_ORIGIN_FIELD_VALUE = "rest";
    public static final String LOCAL_ORIGIN_FIELD_VALUE = "local_node";
    public static final String TRANSPORT_ORIGIN_FIELD_VALUE = "transport";
    public static final String IP_FILTER_ORIGIN_FIELD_VALUE = "ip_filter";
    public static final String SECURITY_CHANGE_ORIGIN_FIELD_VALUE = "security_config_change";
    public static final String LOG_TYPE = "type";
    public static final String TIMESTAMP = "timestamp";
    public static final String ORIGIN_TYPE_FIELD_NAME = "origin.type";
    public static final String ORIGIN_ADDRESS_FIELD_NAME = "origin.address";
    public static final String NODE_NAME_FIELD_NAME = "node.name";
    public static final String NODE_ID_FIELD_NAME = "node.id";
    public static final String HOST_ADDRESS_FIELD_NAME = "host.ip";
    public static final String HOST_NAME_FIELD_NAME = "host.name";
    public static final String CLUSTER_NAME_FIELD_NAME = "cluster.name";
    public static final String CLUSTER_UUID_FIELD_NAME = "cluster.uuid";
    public static final String EVENT_TYPE_FIELD_NAME = "event.type";
    public static final String EVENT_ACTION_FIELD_NAME = "event.action";
    public static final String PRINCIPAL_FIELD_NAME = "user.name";
    public static final String PRINCIPAL_RUN_BY_FIELD_NAME = "user.run_by.name";
    public static final String PRINCIPAL_RUN_AS_FIELD_NAME = "user.run_as.name";
    public static final String PRINCIPAL_REALM_FIELD_NAME = "user.realm";
    public static final String CROSS_CLUSTER_ACCESS_FIELD_NAME = "cross_cluster_access";
    public static final String PRINCIPAL_DOMAIN_FIELD_NAME = "user.realm_domain";
    public static final String PRINCIPAL_RUN_BY_REALM_FIELD_NAME = "user.run_by.realm";
    public static final String PRINCIPAL_RUN_BY_DOMAIN_FIELD_NAME = "user.run_by.realm_domain";
    public static final String PRINCIPAL_RUN_AS_REALM_FIELD_NAME = "user.run_as.realm";
    public static final String PRINCIPAL_RUN_AS_DOMAIN_FIELD_NAME = "user.run_as.realm_domain";
    public static final String API_KEY_ID_FIELD_NAME = "apikey.id";
    public static final String API_KEY_NAME_FIELD_NAME = "apikey.name";
    public static final String SERVICE_TOKEN_NAME_FIELD_NAME = "authentication.token.name";
    public static final String SERVICE_TOKEN_TYPE_FIELD_NAME = "authentication.token.type";
    public static final String PRINCIPAL_ROLES_FIELD_NAME = "user.roles";
    public static final String AUTHENTICATION_TYPE_FIELD_NAME = "authentication.type";
    public static final String REALM_FIELD_NAME = "realm";
    public static final String URL_PATH_FIELD_NAME = "url.path";
    public static final String URL_QUERY_FIELD_NAME = "url.query";
    public static final String REQUEST_METHOD_FIELD_NAME = "request.method";
    public static final String REQUEST_BODY_FIELD_NAME = "request.body";
    public static final String REQUEST_ID_FIELD_NAME = "request.id";
    public static final String ACTION_FIELD_NAME = "action";
    public static final String INDICES_FIELD_NAME = "indices";
    public static final String REQUEST_NAME_FIELD_NAME = "request.name";
    public static final String TRANSPORT_PROFILE_FIELD_NAME = "transport.profile";
    public static final String RULE_FIELD_NAME = "rule";
    public static final String OPAQUE_ID_FIELD_NAME = "opaque_id";
    public static final String TRACE_ID_FIELD_NAME = "trace.id";
    public static final String X_FORWARDED_FOR_FIELD_NAME = "x_forwarded_for";
    public static final String PUT_CONFIG_FIELD_NAME = "put";
    public static final String DELETE_CONFIG_FIELD_NAME = "delete";
    public static final String CHANGE_CONFIG_FIELD_NAME = "change";
    public static final String CREATE_CONFIG_FIELD_NAME = "create";
    public static final String INVALIDATE_API_KEYS_FIELD_NAME = "invalidate";
    public static final String NAME = "logfile";
    public static final Setting<Boolean> EMIT_HOST_ADDRESS_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.emit_node_host_address"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> EMIT_HOST_NAME_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.emit_node_host_name"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> EMIT_NODE_NAME_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.emit_node_name"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> EMIT_NODE_ID_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.emit_node_id"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> EMIT_CLUSTER_NAME_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.emit_cluster_name"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> EMIT_CLUSTER_UUID_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.emit_cluster_uuid"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final List<String> DEFAULT_EVENT_INCLUDES = Arrays.asList(AuditLevel.ACCESS_DENIED.toString(), AuditLevel.ACCESS_GRANTED.toString(), AuditLevel.ANONYMOUS_ACCESS_DENIED.toString(), AuditLevel.AUTHENTICATION_FAILED.toString(), AuditLevel.CONNECTION_DENIED.toString(), AuditLevel.TAMPERED_REQUEST.toString(), AuditLevel.RUN_AS_DENIED.toString(), AuditLevel.RUN_AS_GRANTED.toString(), AuditLevel.SECURITY_CONFIG_CHANGE.toString());
    public static final Setting<List<String>> INCLUDE_EVENT_SETTINGS = Setting.stringListSetting((String)SecurityField.setting((String)"audit.logfile.events.include"), DEFAULT_EVENT_INCLUDES, value -> AuditLevel.parse(value, List.of()), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<List<String>> EXCLUDE_EVENT_SETTINGS = Setting.stringListSetting((String)SecurityField.setting((String)"audit.logfile.events.exclude"), value -> AuditLevel.parse(List.of(), value), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> INCLUDE_REQUEST_BODY = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.events.emit_request_body"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Set<String> SECURITY_CHANGE_ACTIONS = Set.of("cluster:admin/xpack/security/user/put", "cluster:admin/xpack/security/role/put", "cluster:admin/xpack/security/role_mapping/put", ActionTypes.BULK_PUT_ROLES.name(), ActionTypes.BULK_DELETE_ROLES.name(), TransportSetEnabledAction.TYPE.name(), TransportChangePasswordAction.TYPE.name(), "cluster:admin/xpack/security/api_key/create", "cluster:admin/xpack/security/api_key/grant", "cluster:admin/xpack/security/privilege/put", "cluster:admin/xpack/security/user/delete", "cluster:admin/xpack/security/role/delete", "cluster:admin/xpack/security/role_mapping/delete", "cluster:admin/xpack/security/api_key/invalidate", "cluster:admin/xpack/security/privilege/delete", "cluster:admin/xpack/security/service_account/token/create", "cluster:admin/xpack/security/service_account/token/delete", "cluster:admin/xpack/security/profile/activate", "cluster:admin/xpack/security/profile/put/data", "cluster:admin/xpack/security/profile/set_enabled", "cluster:admin/xpack/security/api_key/update", "cluster:admin/xpack/security/api_key/bulk_update", "cluster:admin/xpack/security/cross_cluster/api_key/create", "cluster:admin/xpack/security/cross_cluster/api_key/update");
    private static final String FILTER_POLICY_PREFIX = SecurityField.setting((String)"audit.logfile.events.ignore_filters.");
    protected static final Setting.AffixSetting<List<String>> FILTER_POLICY_IGNORE_PRINCIPALS = Setting.affixKeySetting((String)FILTER_POLICY_PREFIX, (String)"users", key -> Setting.stringListSetting((String)key, List.of("*"), EventFilterPolicy::parsePredicate, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    protected static final Setting.AffixSetting<List<String>> FILTER_POLICY_IGNORE_REALMS = Setting.affixKeySetting((String)FILTER_POLICY_PREFIX, (String)"realms", key -> Setting.stringListSetting((String)key, List.of("*"), EventFilterPolicy::parsePredicate, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    protected static final Setting.AffixSetting<List<String>> FILTER_POLICY_IGNORE_ROLES = Setting.affixKeySetting((String)FILTER_POLICY_PREFIX, (String)"roles", key -> Setting.stringListSetting((String)key, List.of("*"), EventFilterPolicy::parsePredicate, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    protected static final Setting.AffixSetting<List<String>> FILTER_POLICY_IGNORE_INDICES = Setting.affixKeySetting((String)FILTER_POLICY_PREFIX, (String)"indices", key -> Setting.stringListSetting((String)key, List.of("*"), EventFilterPolicy::parsePredicate, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    protected static final Setting.AffixSetting<List<String>> FILTER_POLICY_IGNORE_ACTIONS = Setting.affixKeySetting((String)FILTER_POLICY_PREFIX, (String)"actions", key -> Setting.stringListSetting((String)key, List.of("*"), EventFilterPolicy::parsePredicate, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Marker AUDIT_MARKER = MarkerManager.getMarker((String)"org.elasticsearch.xpack.security.audit");
    private final Logger logger;
    private final ThreadContext threadContext;
    private final SecurityContext securityContext;
    final EventFilterPolicyRegistry eventFilterPolicyRegistry;
    volatile EnumSet<AuditLevel> events;
    boolean includeRequestBody;
    EntryCommonFields entryCommonFields;

    @Override
    public String name() {
        return NAME;
    }

    public LoggingAuditTrail(Settings settings, ClusterService clusterService, ThreadPool threadPool) {
        this(settings, clusterService, LogManager.getLogger(LoggingAuditTrail.class), threadPool.getThreadContext());
    }

    LoggingAuditTrail(Settings settings, ClusterService clusterService, Logger logger, ThreadContext threadContext) {
        this.logger = logger;
        this.events = AuditLevel.parse((List)INCLUDE_EVENT_SETTINGS.get(settings), (List)EXCLUDE_EVENT_SETTINGS.get(settings));
        this.includeRequestBody = (Boolean)INCLUDE_REQUEST_BODY.get(settings);
        this.threadContext = threadContext;
        this.securityContext = new SecurityContext(settings, threadContext);
        this.entryCommonFields = new EntryCommonFields(settings, null, clusterService);
        this.eventFilterPolicyRegistry = new EventFilterPolicyRegistry(settings);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(newSettings -> {
            this.entryCommonFields = this.entryCommonFields.withNewSettings((Settings)newSettings);
            this.includeRequestBody = (Boolean)INCLUDE_REQUEST_BODY.get(newSettings);
            this.events = AuditLevel.parse((List)INCLUDE_EVENT_SETTINGS.get(newSettings), (List)EXCLUDE_EVENT_SETTINGS.get(newSettings));
        }, Arrays.asList(EMIT_HOST_ADDRESS_SETTING, EMIT_HOST_NAME_SETTING, EMIT_NODE_NAME_SETTING, EMIT_NODE_ID_SETTING, EMIT_CLUSTER_NAME_SETTING, EMIT_CLUSTER_UUID_SETTING, INCLUDE_EVENT_SETTINGS, EXCLUDE_EVENT_SETTINGS, INCLUDE_REQUEST_BODY));
        clusterService.getClusterSettings().addAffixGroupUpdateConsumer(List.of(FILTER_POLICY_IGNORE_PRINCIPALS, FILTER_POLICY_IGNORE_REALMS, FILTER_POLICY_IGNORE_ROLES, FILTER_POLICY_IGNORE_INDICES, FILTER_POLICY_IGNORE_ACTIONS), (policyName, updatedSettings) -> {
            if (updatedSettings.keySet().isEmpty()) {
                this.eventFilterPolicyRegistry.remove((String)policyName);
            } else {
                this.eventFilterPolicyRegistry.set((String)policyName, new EventFilterPolicy((String)policyName, (Settings)updatedSettings));
            }
        });
        LoggerContext ctx = LoggerContext.getContext((boolean)false);
        MarkerFilter auditMarkerFilter = MarkerFilter.createFilter((String)AUDIT_MARKER.getName(), (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL);
        ctx.addFilter((Filter)auditMarkerFilter);
        ctx.updateLoggers();
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ignored -> LogManager.getLogger(Security.class).warn("Changing log level for [" + LoggingAuditTrail.class.getName() + "] has no effect"), List.of(Loggers.LOG_LEVEL_SETTING.getConcreteSettingForNamespace(LoggingAuditTrail.class.getName())));
    }

    @Override
    public void authenticationSuccess(RestRequest request) {
        Authentication authentication;
        String requestId = AuditUtil.extractRequestId(this.securityContext.getThreadContext());
        if (requestId == null) {
            throw new ElasticsearchSecurityException("Authenticated context must include request id", new Object[0]);
        }
        try {
            authentication = this.securityContext.getAuthentication();
        }
        catch (Exception e) {
            this.logger.error(() -> Strings.format((String)"caught exception while trying to read authentication from request [%s]", (Object[])new Object[]{request}), (Throwable)e);
            this.tamperedRequest(requestId, (HttpPreRequest)request.getHttpRequest());
            throw new ElasticsearchSecurityException("rest request attempted to inject a user", e, new Object[0]);
        }
        if (authentication == null) {
            throw new ElasticsearchSecurityException("Context is not authenticated", new Object[0]);
        }
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getEffectiveSubject().getUser()), Optional.ofNullable(ApiKeyService.getCreatorRealmName(authentication)), Optional.empty(), Optional.empty(), Optional.empty()))) {
            String authnRealm = authentication.getAuthenticatingSubject().getRealm().getName();
            new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "authentication_success").with(REALM_FIELD_NAME, authnRealm).withRestUriAndMethod((HttpPreRequest)request.getHttpRequest()).withRequestId(requestId).withAuthentication(authentication).withRestOrigin(this.threadContext).withRequestBody(request).withThreadContext(this.securityContext.getThreadContext()).build();
        }
    }

    @Override
    public void authenticationSuccess(String requestId, Authentication authentication, String action, TransportRequest transportRequest) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS)) {
            Optional<String[]> indices = Optional.ofNullable(AuthorizationEngine.RequestInfo.indices((TransportRequest)transportRequest));
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getEffectiveSubject().getUser()), Optional.ofNullable(ApiKeyService.getCreatorRealmName(authentication)), Optional.empty(), indices, Optional.of(action)))) {
                new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "authentication_success").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, transportRequest.getClass().getSimpleName()).withRequestId(requestId).withAuthentication(authentication).withRestOrTransportOrigin(transportRequest, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withThreadContext(this.threadContext).build();
            }
        }
    }

    @Override
    public void anonymousAccessDenied(String requestId, String action, TransportRequest transportRequest) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED)) {
            Optional<String[]> indices = Optional.ofNullable(AuthorizationEngine.RequestInfo.indices((TransportRequest)transportRequest));
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.empty(), Optional.empty(), indices, Optional.of(action)))) {
                new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "anonymous_access_denied").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, transportRequest.getClass().getSimpleName()).withRequestId(requestId).withRestOrTransportOrigin(transportRequest, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withThreadContext(this.threadContext).build();
            }
        }
    }

    @Override
    public void anonymousAccessDenied(String requestId, HttpPreRequest request) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "anonymous_access_denied").withRestUriAndMethod(request).withRestOrigin(this.threadContext).withRequestId(requestId).withThreadContext(this.threadContext).build();
        }
    }

    @Override
    public void authenticationFailed(String requestId, AuthenticationToken token, String action, TransportRequest transportRequest) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            Optional<String[]> indices = Optional.ofNullable(AuthorizationEngine.RequestInfo.indices((TransportRequest)transportRequest));
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(token), Optional.empty(), indices, Optional.of(action)))) {
                LogEntryBuilder logEntryBuilder = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "authentication_failed").with(ACTION_FIELD_NAME, action).with(PRINCIPAL_FIELD_NAME, token.principal()).with(REQUEST_NAME_FIELD_NAME, transportRequest.getClass().getSimpleName()).withRequestId(requestId).withRestOrTransportOrigin(transportRequest, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withThreadContext(this.threadContext);
                if (token instanceof ServiceAccountToken) {
                    logEntryBuilder.with(SERVICE_TOKEN_NAME_FIELD_NAME, ((ServiceAccountToken)token).getTokenName());
                }
                logEntryBuilder.build();
            }
        }
    }

    @Override
    public void authenticationFailed(String requestId, HttpPreRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "authentication_failed").withRestUriAndMethod(request).withRestOrigin(this.threadContext).withRequestId(requestId).withThreadContext(this.threadContext).build();
        }
    }

    @Override
    public void authenticationFailed(String requestId, String action, TransportRequest transportRequest) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            Optional<String[]> indices = Optional.ofNullable(AuthorizationEngine.RequestInfo.indices((TransportRequest)transportRequest));
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.empty(), Optional.empty(), indices, Optional.of(action)))) {
                new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "authentication_failed").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, transportRequest.getClass().getSimpleName()).withRequestId(requestId).withRestOrTransportOrigin(transportRequest, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withThreadContext(this.threadContext).build();
            }
        }
    }

    @Override
    public void authenticationFailed(String requestId, AuthenticationToken token, HttpPreRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(token), Optional.empty(), Optional.empty(), Optional.empty()))) {
            LogEntryBuilder logEntryBuilder = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "authentication_failed").with(PRINCIPAL_FIELD_NAME, token.principal()).withRestUriAndMethod(request).withRestOrigin(this.threadContext).withRequestId(requestId).withThreadContext(this.threadContext);
            if (token instanceof ServiceAccountToken) {
                logEntryBuilder.with(SERVICE_TOKEN_NAME_FIELD_NAME, ((ServiceAccountToken)token).getTokenName());
            }
            logEntryBuilder.build();
        }
    }

    @Override
    public void authenticationFailed(String requestId, String realm, AuthenticationToken token, String action, TransportRequest transportRequest) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED)) {
            Optional<String[]> indices = Optional.ofNullable(AuthorizationEngine.RequestInfo.indices((TransportRequest)transportRequest));
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(token), Optional.of(realm), indices, Optional.of(action)))) {
                new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "realm_authentication_failed").with(REALM_FIELD_NAME, realm).with(PRINCIPAL_FIELD_NAME, token.principal()).with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, transportRequest.getClass().getSimpleName()).withRequestId(requestId).withRestOrTransportOrigin(transportRequest, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withThreadContext(this.threadContext).build();
            }
        }
    }

    @Override
    public void authenticationFailed(String requestId, String realm, AuthenticationToken token, HttpPreRequest request) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(token), Optional.of(realm), Optional.empty(), Optional.empty()))) {
            new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "realm_authentication_failed").with(REALM_FIELD_NAME, realm).with(PRINCIPAL_FIELD_NAME, token.principal()).withRestUriAndMethod(request).withRestOrigin(this.threadContext).withRequestId(requestId).withThreadContext(this.threadContext).build();
        }
    }

    @Override
    public void accessGranted(String requestId, Authentication authentication, String action, TransportRequest msg, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        block55: {
            User user = authentication.getEffectiveSubject().getUser();
            boolean isSystem = user instanceof InternalUser;
            if (isSystem && this.events.contains((Object)AuditLevel.SYSTEM_ACCESS_GRANTED) || !isSystem && this.events.contains((Object)AuditLevel.ACCESS_GRANTED)) {
                Optional<String[]> indices = Optional.ofNullable(AuthorizationEngine.RequestInfo.indices((TransportRequest)msg));
                if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(user), Optional.ofNullable(ApiKeyService.getCreatorRealmName(authentication)), Optional.of(authorizationInfo), indices, Optional.of(action)))) {
                    new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "access_granted").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, msg.getClass().getSimpleName()).withRequestId(requestId).withAuthentication(authentication).withRestOrTransportOrigin(msg, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withThreadContext(this.threadContext).with(authorizationInfo.asMap()).build();
                }
            }
            if (this.events.contains((Object)AuditLevel.SECURITY_CONFIG_CHANGE) && SECURITY_CHANGE_ACTIONS.contains(action)) {
                try {
                    if (msg instanceof PutUserRequest) {
                        assert ("cluster:admin/xpack/security/user/put".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((PutUserRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof PutRoleRequest) {
                        assert ("cluster:admin/xpack/security/role/put".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((PutRoleRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof BulkPutRolesRequest) {
                        BulkPutRolesRequest bulkPutRolesRequest = (BulkPutRolesRequest)msg;
                        assert (ActionTypes.BULK_PUT_ROLES.name().equals(action));
                        for (RoleDescriptor roleDescriptor : bulkPutRolesRequest.getRoles()) {
                            this.securityChangeLogEntryBuilder(requestId).withRequestBody(roleDescriptor.getName(), roleDescriptor).build();
                        }
                        break block55;
                    }
                    if (msg instanceof PutRoleMappingRequest) {
                        assert ("cluster:admin/xpack/security/role_mapping/put".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((PutRoleMappingRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof SetEnabledRequest) {
                        assert (TransportSetEnabledAction.TYPE.name().equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((SetEnabledRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof ChangePasswordRequest) {
                        assert (TransportChangePasswordAction.TYPE.name().equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((ChangePasswordRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof CreateApiKeyRequest) {
                        assert ("cluster:admin/xpack/security/api_key/create".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((AbstractCreateApiKeyRequest)((CreateApiKeyRequest)msg)).build();
                        break block55;
                    }
                    if (msg instanceof GrantApiKeyRequest) {
                        assert ("cluster:admin/xpack/security/api_key/grant".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((GrantApiKeyRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof PutPrivilegesRequest) {
                        assert ("cluster:admin/xpack/security/privilege/put".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((PutPrivilegesRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof DeleteUserRequest) {
                        assert ("cluster:admin/xpack/security/user/delete".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((DeleteUserRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof DeleteRoleRequest) {
                        assert ("cluster:admin/xpack/security/role/delete".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((DeleteRoleRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof BulkDeleteRolesRequest) {
                        BulkDeleteRolesRequest bulkDeleteRolesRequest = (BulkDeleteRolesRequest)msg;
                        assert (ActionTypes.BULK_DELETE_ROLES.name().equals(action));
                        for (String roleName : bulkDeleteRolesRequest.getRoleNames()) {
                            this.securityChangeLogEntryBuilder(requestId).withDeleteRole(roleName).build();
                        }
                        break block55;
                    }
                    if (msg instanceof DeleteRoleMappingRequest) {
                        assert ("cluster:admin/xpack/security/role_mapping/delete".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((DeleteRoleMappingRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof InvalidateApiKeyRequest) {
                        assert ("cluster:admin/xpack/security/api_key/invalidate".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((InvalidateApiKeyRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof DeletePrivilegesRequest) {
                        assert ("cluster:admin/xpack/security/privilege/delete".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((DeletePrivilegesRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof CreateServiceAccountTokenRequest) {
                        assert ("cluster:admin/xpack/security/service_account/token/create".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((CreateServiceAccountTokenRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof DeleteServiceAccountTokenRequest) {
                        assert ("cluster:admin/xpack/security/service_account/token/delete".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((DeleteServiceAccountTokenRequest)msg).build();
                        break block55;
                    }
                    if (msg instanceof ActivateProfileRequest) {
                        ActivateProfileRequest activateProfileRequest = (ActivateProfileRequest)msg;
                        assert ("cluster:admin/xpack/security/profile/activate".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody(activateProfileRequest).build();
                        break block55;
                    }
                    if (msg instanceof UpdateProfileDataRequest) {
                        UpdateProfileDataRequest updateProfileDataRequest = (UpdateProfileDataRequest)msg;
                        assert ("cluster:admin/xpack/security/profile/put/data".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody(updateProfileDataRequest).build();
                        break block55;
                    }
                    if (msg instanceof SetProfileEnabledRequest) {
                        SetProfileEnabledRequest setProfileEnabledRequest = (SetProfileEnabledRequest)msg;
                        assert ("cluster:admin/xpack/security/profile/set_enabled".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody(setProfileEnabledRequest).build();
                        break block55;
                    }
                    if (msg instanceof UpdateApiKeyRequest) {
                        UpdateApiKeyRequest updateApiKeyRequest = (UpdateApiKeyRequest)msg;
                        assert ("cluster:admin/xpack/security/api_key/update".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((BaseSingleUpdateApiKeyRequest)updateApiKeyRequest).build();
                        break block55;
                    }
                    if (msg instanceof BulkUpdateApiKeyRequest) {
                        BulkUpdateApiKeyRequest bulkUpdateApiKeyRequest = (BulkUpdateApiKeyRequest)msg;
                        assert ("cluster:admin/xpack/security/api_key/bulk_update".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody(bulkUpdateApiKeyRequest).build();
                        break block55;
                    }
                    if (msg instanceof CreateCrossClusterApiKeyRequest) {
                        CreateCrossClusterApiKeyRequest createCrossClusterApiKeyRequest = (CreateCrossClusterApiKeyRequest)msg;
                        assert ("cluster:admin/xpack/security/cross_cluster/api_key/create".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((AbstractCreateApiKeyRequest)createCrossClusterApiKeyRequest).build();
                        break block55;
                    }
                    if (msg instanceof UpdateCrossClusterApiKeyRequest) {
                        UpdateCrossClusterApiKeyRequest updateCrossClusterApiKeyRequest = (UpdateCrossClusterApiKeyRequest)msg;
                        assert ("cluster:admin/xpack/security/cross_cluster/api_key/update".equals(action));
                        this.securityChangeLogEntryBuilder(requestId).withRequestBody((BaseSingleUpdateApiKeyRequest)updateCrossClusterApiKeyRequest).build();
                        break block55;
                    }
                    throw new IllegalStateException("Unknown message class type [" + msg.getClass().getSimpleName() + "] for the \"security change\" action [" + action + "]");
                }
                catch (IOException e) {
                    throw new ElasticsearchSecurityException("Unexpected error while serializing event data", (Exception)e, new Object[0]);
                }
            }
        }
    }

    @Override
    public void explicitIndexAccessEvent(String requestId, AuditLevel eventType, Authentication authentication, String action, String[] indices, String requestName, InetSocketAddress remoteAddress, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        assert (eventType == AuditLevel.ACCESS_DENIED || eventType == AuditLevel.ACCESS_GRANTED || eventType == AuditLevel.SYSTEM_ACCESS_GRANTED);
        User user = authentication.getEffectiveSubject().getUser();
        if (user instanceof InternalUser && eventType == AuditLevel.ACCESS_GRANTED) {
            eventType = AuditLevel.SYSTEM_ACCESS_GRANTED;
        }
        if (this.events.contains((Object)eventType) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(user), Optional.ofNullable(ApiKeyService.getCreatorRealmName(authentication)), Optional.of(authorizationInfo), Optional.of(indices), Optional.of(action)))) {
            LogEntryBuilder logEntryBuilder = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, eventType == AuditLevel.ACCESS_DENIED ? "access_denied" : "access_granted").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, requestName).withRequestId(requestId).withAuthentication(authentication).with(INDICES_FIELD_NAME, indices).withThreadContext(this.threadContext).with(authorizationInfo.asMap());
            InetSocketAddress restAddress = RemoteHostHeader.restRemoteAddress(this.threadContext);
            if (restAddress != null) {
                logEntryBuilder.with(ORIGIN_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetSocketAddress)restAddress));
            } else if (remoteAddress != null) {
                logEntryBuilder.with(ORIGIN_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetSocketAddress)remoteAddress));
            }
            logEntryBuilder.build();
        }
    }

    @Override
    public void accessDenied(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (this.events.contains((Object)AuditLevel.ACCESS_DENIED)) {
            Optional<String[]> indices = Optional.ofNullable(AuthorizationEngine.RequestInfo.indices((TransportRequest)transportRequest));
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getEffectiveSubject().getUser()), Optional.ofNullable(ApiKeyService.getCreatorRealmName(authentication)), Optional.of(authorizationInfo), indices, Optional.of(action)))) {
                new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "access_denied").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, transportRequest.getClass().getSimpleName()).withRequestId(requestId).withAuthentication(authentication).withRestOrTransportOrigin(transportRequest, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).with(authorizationInfo.asMap()).withThreadContext(this.threadContext).build();
            }
        }
    }

    @Override
    public void tamperedRequest(String requestId, HttpPreRequest request) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "tampered_request").withRestUriAndMethod(request).withRestOrigin(this.threadContext).withRequestId(requestId).withThreadContext(this.threadContext).build();
        }
    }

    @Override
    public void tamperedRequest(String requestId, String action, TransportRequest transportRequest) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            Optional<String[]> indices = Optional.ofNullable(AuthorizationEngine.RequestInfo.indices((TransportRequest)transportRequest));
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.empty(), Optional.empty(), indices, Optional.of(action)))) {
                new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "tampered_request").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, transportRequest.getClass().getSimpleName()).withRequestId(requestId).withRestOrTransportOrigin(transportRequest, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withThreadContext(this.threadContext).build();
            }
        }
    }

    @Override
    public void tamperedRequest(String requestId, Authentication authentication, String action, TransportRequest transportRequest) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            Optional<String[]> indices = Optional.ofNullable(AuthorizationEngine.RequestInfo.indices((TransportRequest)transportRequest));
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getEffectiveSubject().getUser()), Optional.ofNullable(ApiKeyService.getCreatorRealmName(authentication)), Optional.empty(), indices, Optional.of(action)))) {
                new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "tampered_request").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, transportRequest.getClass().getSimpleName()).withRequestId(requestId).withRestOrTransportOrigin(transportRequest, this.threadContext).withAuthentication(authentication).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withThreadContext(this.threadContext).build();
            }
        }
    }

    @Override
    public void connectionGranted(InetSocketAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_GRANTED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, IP_FILTER_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "connection_granted").with(ORIGIN_TYPE_FIELD_NAME, ".http".equals(profile) ? REST_ORIGIN_FIELD_VALUE : TRANSPORT_ORIGIN_FIELD_VALUE).with(ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetSocketAddress)inetAddress)).with(TRANSPORT_PROFILE_FIELD_NAME, profile).with(RULE_FIELD_NAME, rule.toString()).withThreadContext(this.threadContext).build();
        }
    }

    @Override
    public void connectionDenied(InetSocketAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_DENIED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, IP_FILTER_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "connection_denied").with(ORIGIN_TYPE_FIELD_NAME, ".http".equals(profile) ? REST_ORIGIN_FIELD_VALUE : TRANSPORT_ORIGIN_FIELD_VALUE).with(ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetSocketAddress)inetAddress)).with(TRANSPORT_PROFILE_FIELD_NAME, profile).with(RULE_FIELD_NAME, rule.toString()).withThreadContext(this.threadContext).build();
        }
    }

    @Override
    public void runAsGranted(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_GRANTED)) {
            Optional<String[]> indices = Optional.ofNullable(AuthorizationEngine.RequestInfo.indices((TransportRequest)transportRequest));
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getEffectiveSubject().getUser()), Optional.ofNullable(ApiKeyService.getCreatorRealmName(authentication)), Optional.of(authorizationInfo), indices, Optional.of(action)))) {
                new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "run_as_granted").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, transportRequest.getClass().getSimpleName()).withRequestId(requestId).withRunAsSubject(authentication).withRestOrTransportOrigin(transportRequest, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).with(authorizationInfo.asMap()).withThreadContext(this.threadContext).build();
            }
        }
    }

    @Override
    public void runAsDenied(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED)) {
            Optional<String[]> indices = Optional.ofNullable(AuthorizationEngine.RequestInfo.indices((TransportRequest)transportRequest));
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getEffectiveSubject().getUser()), Optional.ofNullable(ApiKeyService.getCreatorRealmName(authentication)), Optional.of(authorizationInfo), indices, Optional.of(action)))) {
                new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "run_as_denied").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, transportRequest.getClass().getSimpleName()).withRequestId(requestId).withRunAsSubject(authentication).withRestOrTransportOrigin(transportRequest, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).with(authorizationInfo.asMap()).withThreadContext(this.threadContext).build();
            }
        }
    }

    @Override
    public void runAsDenied(String requestId, Authentication authentication, HttpPreRequest request, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getEffectiveSubject().getUser()), Optional.ofNullable(ApiKeyService.getCreatorRealmName(authentication)), Optional.of(authorizationInfo), Optional.empty(), Optional.empty()))) {
            new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "run_as_denied").with(authorizationInfo.asMap()).withRestUriAndMethod(request).withRunAsSubject(authentication).withRestOrigin(this.threadContext).withRequestId(requestId).withThreadContext(this.threadContext).build();
        }
    }

    @Override
    public void coordinatingActionResponse(String requestId, Authentication authentication, String action, TransportRequest transportRequest, TransportResponse transportResponse) {
    }

    private LogEntryBuilder securityChangeLogEntryBuilder(String requestId) {
        return new LogEntryBuilder(false).with(EVENT_TYPE_FIELD_NAME, SECURITY_CHANGE_ORIGIN_FIELD_VALUE).withRequestId(requestId);
    }

    public static void registerSettings(List<Setting<?>> settings) {
        settings.add(EMIT_HOST_ADDRESS_SETTING);
        settings.add(EMIT_HOST_NAME_SETTING);
        settings.add(EMIT_NODE_NAME_SETTING);
        settings.add(EMIT_NODE_ID_SETTING);
        settings.add(EMIT_CLUSTER_NAME_SETTING);
        settings.add(EMIT_CLUSTER_UUID_SETTING);
        settings.add(INCLUDE_EVENT_SETTINGS);
        settings.add(EXCLUDE_EVENT_SETTINGS);
        settings.add(INCLUDE_REQUEST_BODY);
        settings.add((Setting<?>)FILTER_POLICY_IGNORE_PRINCIPALS);
        settings.add((Setting<?>)FILTER_POLICY_IGNORE_INDICES);
        settings.add((Setting<?>)FILTER_POLICY_IGNORE_ROLES);
        settings.add((Setting<?>)FILTER_POLICY_IGNORE_REALMS);
        settings.add((Setting<?>)FILTER_POLICY_IGNORE_ACTIONS);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        this.updateLocalNodeInfo(event.state().getNodes().getLocalNode());
    }

    void updateLocalNodeInfo(DiscoveryNode newLocalNode) {
        EntryCommonFields localNodeInfo = this.entryCommonFields;
        if (localNodeInfo.localNode == null || !localNodeInfo.localNode.equals((Object)newLocalNode)) {
            this.entryCommonFields = this.entryCommonFields.withNewLocalNode(newLocalNode);
        }
    }

    static class EntryCommonFields {
        private final Settings settings;
        private final DiscoveryNode localNode;
        private final ClusterService clusterService;
        final Map<String, String> commonFields;

        EntryCommonFields(Settings settings, @Nullable DiscoveryNode newLocalNode, ClusterService clusterService) {
            String nodeName;
            this.settings = settings;
            this.localNode = newLocalNode;
            this.clusterService = clusterService;
            HashMap<String, String> commonFields = new HashMap<String, String>();
            if (((Boolean)EMIT_NODE_NAME_SETTING.get(settings)).booleanValue() && org.elasticsearch.common.Strings.hasLength((String)(nodeName = (String)Node.NODE_NAME_SETTING.get(settings)))) {
                commonFields.put(LoggingAuditTrail.NODE_NAME_FIELD_NAME, nodeName);
            }
            if (newLocalNode != null && newLocalNode.getAddress() != null) {
                if (((Boolean)EMIT_HOST_ADDRESS_SETTING.get(settings)).booleanValue()) {
                    commonFields.put(LoggingAuditTrail.HOST_ADDRESS_FIELD_NAME, newLocalNode.getAddress().getAddress());
                }
                if (((Boolean)EMIT_HOST_NAME_SETTING.get(settings)).booleanValue()) {
                    commonFields.put(LoggingAuditTrail.HOST_NAME_FIELD_NAME, newLocalNode.getAddress().address().getHostString());
                }
                if (((Boolean)EMIT_NODE_ID_SETTING.get(settings)).booleanValue()) {
                    commonFields.put(LoggingAuditTrail.NODE_ID_FIELD_NAME, newLocalNode.getId());
                }
                commonFields.put(LoggingAuditTrail.ORIGIN_ADDRESS_FIELD_NAME, newLocalNode.getAddress().toString());
            }
            commonFields.put(LoggingAuditTrail.ORIGIN_TYPE_FIELD_NAME, LoggingAuditTrail.LOCAL_ORIGIN_FIELD_VALUE);
            if (Lifecycle.State.STARTED.equals((Object)clusterService.lifecycleState())) {
                ClusterState clusterState = this.clusterService.state();
                if (clusterState == null) {
                    LOGGER.trace("Cluster state not available");
                } else {
                    String clusterUuId;
                    String clusterName;
                    if (((Boolean)EMIT_CLUSTER_NAME_SETTING.get(settings)).booleanValue() && org.elasticsearch.common.Strings.hasLength((String)(clusterName = clusterState.getClusterName().value()))) {
                        commonFields.put(LoggingAuditTrail.CLUSTER_NAME_FIELD_NAME, clusterName);
                    }
                    if (((Boolean)EMIT_CLUSTER_UUID_SETTING.get(settings)).booleanValue() && org.elasticsearch.common.Strings.hasLength((String)(clusterUuId = clusterState.metadata().clusterUUID()))) {
                        commonFields.put(LoggingAuditTrail.CLUSTER_UUID_FIELD_NAME, clusterUuId);
                    }
                }
            }
            commonFields.putIfAbsent(LoggingAuditTrail.NODE_NAME_FIELD_NAME, null);
            commonFields.putIfAbsent(LoggingAuditTrail.NODE_ID_FIELD_NAME, null);
            commonFields.putIfAbsent(LoggingAuditTrail.HOST_ADDRESS_FIELD_NAME, null);
            commonFields.putIfAbsent(LoggingAuditTrail.HOST_NAME_FIELD_NAME, null);
            commonFields.putIfAbsent(LoggingAuditTrail.CLUSTER_NAME_FIELD_NAME, null);
            commonFields.putIfAbsent(LoggingAuditTrail.CLUSTER_UUID_FIELD_NAME, null);
            this.commonFields = Collections.unmodifiableMap(commonFields);
        }

        EntryCommonFields withNewSettings(Settings newSettings) {
            Settings mergedSettings = Settings.builder().put(this.settings).put(newSettings, false).build();
            return new EntryCommonFields(mergedSettings, this.localNode, this.clusterService);
        }

        EntryCommonFields withNewLocalNode(DiscoveryNode newLocalNode) {
            return new EntryCommonFields(this.settings, newLocalNode, this.clusterService);
        }
    }

    static final class EventFilterPolicyRegistry {
        private volatile Map<String, EventFilterPolicy> policyMap;
        private volatile Predicate<AuditEventMetaInfo> predicate;

        private EventFilterPolicyRegistry(Settings settings) {
            ArrayList<Map.Entry<String, EventFilterPolicy>> entries = new ArrayList<Map.Entry<String, EventFilterPolicy>>();
            for (String policyName : settings.getGroups(FILTER_POLICY_PREFIX, true).keySet()) {
                entries.add(Map.entry(policyName, new EventFilterPolicy(policyName, settings)));
            }
            this.policyMap = Maps.ofEntries(entries);
            this.predicate = EventFilterPolicyRegistry.buildIgnorePredicate(this.policyMap);
        }

        private synchronized void set(String policyName, EventFilterPolicy eventFilterPolicy) {
            this.policyMap = Maps.copyMapWithAddedOrReplacedEntry(this.policyMap, (Object)policyName, (Object)eventFilterPolicy);
            this.predicate = EventFilterPolicyRegistry.buildIgnorePredicate(this.policyMap);
        }

        private synchronized void remove(String policyName) {
            this.policyMap = Maps.copyMapWithRemovedEntry(this.policyMap, (Object)policyName);
            this.predicate = EventFilterPolicyRegistry.buildIgnorePredicate(this.policyMap);
        }

        Predicate<AuditEventMetaInfo> ignorePredicate() {
            return this.predicate;
        }

        private static Predicate<AuditEventMetaInfo> buildIgnorePredicate(Map<String, EventFilterPolicy> policyMap) {
            return policyMap.values().stream().map(EventFilterPolicy::ignorePredicate).reduce(Predicates.never(), Predicate::or);
        }

        public String toString() {
            TreeMap<String, EventFilterPolicy> treeMap = new TreeMap<String, EventFilterPolicy>(this.policyMap);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : treeMap.entrySet()) {
                sb.append((String)entry.getKey()).append(":").append(((EventFilterPolicy)entry.getValue()).toString());
            }
            return sb.toString();
        }
    }

    static final class AuditEventMetaInfo {
        final String principal;
        final String realm;
        final String action;
        final Supplier<Stream<String>> roles;
        final Supplier<Stream<String>> indices;
        static final AuditEventMetaInfo EMPTY = new AuditEventMetaInfo(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());

        AuditEventMetaInfo(Optional<User> user, Optional<String> realm, Optional<AuthorizationEngine.AuthorizationInfo> authorizationInfo, Optional<String[]> indices, Optional<String> action) {
            this.principal = user.map(u -> u.principal()).orElse("");
            this.realm = realm.orElse("");
            this.action = action.orElse("");
            this.roles = () -> authorizationInfo.filter(info -> {
                Object value = info.asMap().get(LoggingAuditTrail.PRINCIPAL_ROLES_FIELD_NAME);
                return value instanceof String[] && ((String[])value).length != 0 && Arrays.stream((String[])value).anyMatch(Objects::nonNull);
            }).map(info -> Arrays.stream((String[])info.asMap().get(LoggingAuditTrail.PRINCIPAL_ROLES_FIELD_NAME))).orElse(Stream.of(""));
            this.indices = () -> indices.filter(i -> ((String[])i).length > 0).filter(a -> Arrays.stream(a).anyMatch(Objects::nonNull)).map(Arrays::stream).orElse(Stream.of(""));
        }

        AuditEventMetaInfo(Optional<AuthenticationToken> authenticationToken, Optional<String> realm, Optional<String[]> indices, Optional<String> action) {
            this.principal = authenticationToken.map(u -> u.principal()).orElse("");
            this.realm = realm.orElse("");
            this.action = action.orElse("");
            this.roles = () -> Stream.of("");
            this.indices = () -> indices.filter(r -> ((String[])r).length != 0).map(i -> Arrays.stream(i)).orElse(Stream.of(""));
        }
    }

    private class LogEntryBuilder {
        private final StringMapMessage logEntry;

        LogEntryBuilder() {
            this(true);
        }

        LogEntryBuilder(boolean showOrigin) {
            this.logEntry = new StringMapMessage(LoggingAuditTrail.this.entryCommonFields.commonFields);
            if (!showOrigin) {
                this.logEntry.remove(LoggingAuditTrail.ORIGIN_ADDRESS_FIELD_NAME);
                this.logEntry.remove(LoggingAuditTrail.ORIGIN_TYPE_FIELD_NAME);
            }
        }

        LogEntryBuilder withRequestBody(PutUserRequest putUserRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "put_user");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject().startObject("user").field("name", putUserRequest.username()).field("enabled", putUserRequest.enabled()).array("roles", putUserRequest.roles());
            if (putUserRequest.fullName() != null) {
                builder.field("full_name", putUserRequest.fullName());
            }
            if (putUserRequest.email() != null) {
                builder.field("email", putUserRequest.email());
            }
            builder.field("has_password", putUserRequest.passwordHash() != null);
            if (putUserRequest.metadata() != null && !putUserRequest.metadata().isEmpty()) {
                builder.field("metadata", putUserRequest.metadata());
            }
            builder.endObject().endObject();
            this.logEntry.with(LoggingAuditTrail.PUT_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(ChangePasswordRequest changePasswordRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "change_password");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject().startObject("password").startObject("user").field("name", changePasswordRequest.username()).endObject().endObject().endObject();
            this.logEntry.with(LoggingAuditTrail.CHANGE_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(PutRoleRequest putRoleRequest) throws IOException {
            return this.withRequestBody(putRoleRequest.name(), putRoleRequest.roleDescriptor());
        }

        LogEntryBuilder withRequestBody(String roleName, RoleDescriptor roleDescriptor) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "put_role");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject().startObject("role").field("name", roleName).field("role_descriptor");
            LogEntryBuilder.withRoleDescriptor(builder, roleDescriptor);
            builder.endObject().endObject();
            this.logEntry.with(LoggingAuditTrail.PUT_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(PutRoleMappingRequest putRoleMappingRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "put_role_mapping");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject().startObject("role_mapping").field("name", putRoleMappingRequest.getName());
            if (putRoleMappingRequest.getRoles() != null && !putRoleMappingRequest.getRoles().isEmpty()) {
                builder.field("roles", (Collection)putRoleMappingRequest.getRoles());
            }
            if (putRoleMappingRequest.getRoleTemplates() != null && !putRoleMappingRequest.getRoleTemplates().isEmpty()) {
                builder.field("role_templates", (Iterable)putRoleMappingRequest.getRoleTemplates());
            }
            builder.field("rules", (ToXContent)putRoleMappingRequest.getRules()).field("enabled", putRoleMappingRequest.isEnabled());
            if (putRoleMappingRequest.getMetadata() != null && !putRoleMappingRequest.getMetadata().isEmpty()) {
                builder.field("metadata", putRoleMappingRequest.getMetadata());
            }
            builder.endObject().endObject();
            this.logEntry.with(LoggingAuditTrail.PUT_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(SetEnabledRequest setEnabledRequest) throws IOException {
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            if (setEnabledRequest.enabled() != null && setEnabledRequest.enabled().booleanValue()) {
                builder.startObject().startObject("enable").startObject("user").field("name", setEnabledRequest.username()).endObject().endObject().endObject();
                this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "change_enable_user");
            } else {
                builder.startObject().startObject("disable").startObject("user").field("name", setEnabledRequest.username()).endObject().endObject().endObject();
                this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "change_disable_user");
            }
            this.logEntry.with(LoggingAuditTrail.CHANGE_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(PutPrivilegesRequest putPrivilegesRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "put_privileges");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject().field("privileges", (Iterable)putPrivilegesRequest.getPrivileges()).endObject();
            this.logEntry.with(LoggingAuditTrail.PUT_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(AbstractCreateApiKeyRequest abstractCreateApiKeyRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "create_apikey");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject();
            LogEntryBuilder.withRequestBody(builder, abstractCreateApiKeyRequest);
            builder.endObject();
            this.logEntry.with(LoggingAuditTrail.CREATE_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(GrantApiKeyRequest grantApiKeyRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "create_apikey");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject();
            LogEntryBuilder.withRequestBody(builder, (AbstractCreateApiKeyRequest)grantApiKeyRequest.getApiKeyRequest());
            Grant grant = grantApiKeyRequest.getGrant();
            LogEntryBuilder.withGrant(builder, grant);
            builder.endObject();
            this.logEntry.with(LoggingAuditTrail.CREATE_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(BaseSingleUpdateApiKeyRequest baseSingleUpdateApiKeyRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "change_apikey");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject();
            LogEntryBuilder.withRequestBody(builder, baseSingleUpdateApiKeyRequest);
            builder.endObject();
            this.logEntry.with(LoggingAuditTrail.CHANGE_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(BulkUpdateApiKeyRequest bulkUpdateApiKeyRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "change_apikeys");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject();
            LogEntryBuilder.withRequestBody(builder, bulkUpdateApiKeyRequest);
            builder.endObject();
            this.logEntry.with(LoggingAuditTrail.CHANGE_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        private static void withRequestBody(XContentBuilder builder, AbstractCreateApiKeyRequest abstractCreateApiKeyRequest) throws IOException {
            TimeValue expiration = abstractCreateApiKeyRequest.getExpiration();
            builder.startObject("apikey").field("id", abstractCreateApiKeyRequest.getId()).field("name", abstractCreateApiKeyRequest.getName()).field(LoggingAuditTrail.LOG_TYPE, abstractCreateApiKeyRequest.getType().value()).field("expiration", expiration != null ? expiration.toString() : null).startArray("role_descriptors");
            for (RoleDescriptor roleDescriptor : abstractCreateApiKeyRequest.getRoleDescriptors()) {
                LogEntryBuilder.withRoleDescriptor(builder, roleDescriptor);
            }
            builder.endArray();
            if (abstractCreateApiKeyRequest.getMetadata() != null && !abstractCreateApiKeyRequest.getMetadata().isEmpty()) {
                builder.field("metadata", abstractCreateApiKeyRequest.getMetadata());
            }
            builder.endObject();
        }

        private static void withRequestBody(XContentBuilder builder, BaseSingleUpdateApiKeyRequest baseSingleUpdateApiKeyRequest) throws IOException {
            builder.startObject("apikey").field("id", baseSingleUpdateApiKeyRequest.getId());
            LogEntryBuilder.withBaseUpdateApiKeyFields(builder, (BaseUpdateApiKeyRequest)baseSingleUpdateApiKeyRequest);
            builder.endObject();
        }

        private static void withRequestBody(XContentBuilder builder, BulkUpdateApiKeyRequest bulkUpdateApiKeyRequest) throws IOException {
            builder.startObject("apikeys").stringListField("ids", (Collection)bulkUpdateApiKeyRequest.getIds());
            LogEntryBuilder.withBaseUpdateApiKeyFields(builder, (BaseUpdateApiKeyRequest)bulkUpdateApiKeyRequest);
            builder.endObject();
        }

        private static void withBaseUpdateApiKeyFields(XContentBuilder builder, BaseUpdateApiKeyRequest baseUpdateApiKeyRequest) throws IOException {
            builder.field(LoggingAuditTrail.LOG_TYPE, baseUpdateApiKeyRequest.getType().value());
            if (baseUpdateApiKeyRequest.getRoleDescriptors() != null) {
                builder.startArray("role_descriptors");
                for (RoleDescriptor roleDescriptor : baseUpdateApiKeyRequest.getRoleDescriptors()) {
                    LogEntryBuilder.withRoleDescriptor(builder, roleDescriptor);
                }
                builder.endArray();
            }
            if (baseUpdateApiKeyRequest.getMetadata() != null) {
                builder.field("metadata", baseUpdateApiKeyRequest.getMetadata());
            }
            builder.field("expiration", baseUpdateApiKeyRequest.getExpiration() != null ? baseUpdateApiKeyRequest.getExpiration().toString() : null);
        }

        private static void withRoleDescriptor(XContentBuilder builder, RoleDescriptor roleDescriptor) throws IOException {
            builder.startObject().array(RoleDescriptor.Fields.CLUSTER.getPreferredName(), roleDescriptor.getClusterPrivileges());
            if (roleDescriptor.getConditionalClusterPrivileges() != null && roleDescriptor.getConditionalClusterPrivileges().length > 0) {
                builder.field(RoleDescriptor.Fields.GLOBAL.getPreferredName());
                ConfigurableClusterPrivileges.toXContent((XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS, Arrays.asList(roleDescriptor.getConditionalClusterPrivileges()));
            }
            builder.startArray(RoleDescriptor.Fields.INDICES.getPreferredName());
            for (RoleDescriptor.IndicesPrivileges indicesPrivileges : roleDescriptor.getIndicesPrivileges()) {
                LogEntryBuilder.withIndicesPrivileges(builder, indicesPrivileges);
            }
            builder.endArray();
            builder.xContentList(RoleDescriptor.Fields.APPLICATIONS.getPreferredName(), (ToXContent[])roleDescriptor.getApplicationPrivileges());
            builder.array(RoleDescriptor.Fields.RUN_AS.getPreferredName(), roleDescriptor.getRunAs());
            if (roleDescriptor.getMetadata() != null && !roleDescriptor.getMetadata().isEmpty()) {
                builder.field(RoleDescriptor.Fields.METADATA.getPreferredName(), roleDescriptor.getMetadata());
            }
            builder.endObject();
        }

        private static void withIndicesPrivileges(XContentBuilder builder, RoleDescriptor.IndicesPrivileges indicesPrivileges) throws IOException {
            builder.startObject();
            builder.array("names", indicesPrivileges.getIndices());
            builder.array("privileges", indicesPrivileges.getPrivileges());
            if (indicesPrivileges.isUsingFieldLevelSecurity()) {
                builder.startObject(RoleDescriptor.Fields.FIELD_PERMISSIONS.getPreferredName());
                builder.array(RoleDescriptor.Fields.GRANT_FIELDS.getPreferredName(), indicesPrivileges.getGrantedFields());
                if (indicesPrivileges.hasDeniedFields()) {
                    builder.array(RoleDescriptor.Fields.EXCEPT_FIELDS.getPreferredName(), indicesPrivileges.getDeniedFields());
                }
                builder.endObject();
            }
            if (indicesPrivileges.isUsingDocumentLevelSecurity()) {
                builder.field("query", indicesPrivileges.getQuery().utf8ToString());
            }
            if (indicesPrivileges.allowRestrictedIndices()) {
                builder.field("allow_restricted_indices", indicesPrivileges.allowRestrictedIndices());
            }
            builder.endObject();
        }

        LogEntryBuilder withRequestBody(DeleteUserRequest deleteUserRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "delete_user");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject().startObject("user").field("name", deleteUserRequest.username()).endObject().endObject();
            this.logEntry.with(LoggingAuditTrail.DELETE_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(DeleteRoleRequest deleteRoleRequest) throws IOException {
            return this.withDeleteRole(deleteRoleRequest.name());
        }

        LogEntryBuilder withRequestBody(DeleteRoleMappingRequest deleteRoleMappingRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "delete_role_mapping");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject().startObject("role_mapping").field("name", deleteRoleMappingRequest.getName()).endObject().endObject();
            this.logEntry.with(LoggingAuditTrail.DELETE_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(InvalidateApiKeyRequest invalidateApiKeyRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "invalidate_apikeys");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject().startObject("apikeys");
            if (invalidateApiKeyRequest.getIds() != null && invalidateApiKeyRequest.getIds().length > 0) {
                builder.array("ids", invalidateApiKeyRequest.getIds());
            }
            if (org.elasticsearch.common.Strings.hasLength((String)invalidateApiKeyRequest.getName())) {
                builder.field("name", invalidateApiKeyRequest.getName());
            }
            builder.field("owned_by_authenticated_user", invalidateApiKeyRequest.ownedByAuthenticatedUser());
            if (org.elasticsearch.common.Strings.hasLength((String)invalidateApiKeyRequest.getUserName()) || org.elasticsearch.common.Strings.hasLength((String)invalidateApiKeyRequest.getRealmName())) {
                builder.startObject("user").field("name", invalidateApiKeyRequest.getUserName()).field(LoggingAuditTrail.REALM_FIELD_NAME, invalidateApiKeyRequest.getRealmName()).endObject();
            }
            builder.endObject().endObject();
            this.logEntry.with(LoggingAuditTrail.INVALIDATE_API_KEYS_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(DeletePrivilegesRequest deletePrivilegesRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "delete_privileges");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject().startObject("privileges").field("application", deletePrivilegesRequest.application()).array("privileges", deletePrivilegesRequest.privileges()).endObject().endObject();
            this.logEntry.with(LoggingAuditTrail.DELETE_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(CreateServiceAccountTokenRequest createServiceAccountTokenRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "create_service_token");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject().startObject("service_token").field("namespace", createServiceAccountTokenRequest.getNamespace()).field("service", createServiceAccountTokenRequest.getServiceName()).field("name", createServiceAccountTokenRequest.getTokenName()).endObject().endObject();
            this.logEntry.with(LoggingAuditTrail.CREATE_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(DeleteServiceAccountTokenRequest deleteServiceAccountTokenRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "delete_service_token");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject().startObject("service_token").field("namespace", deleteServiceAccountTokenRequest.getNamespace()).field("service", deleteServiceAccountTokenRequest.getServiceName()).field("name", deleteServiceAccountTokenRequest.getTokenName()).endObject().endObject();
            this.logEntry.with(LoggingAuditTrail.DELETE_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(ActivateProfileRequest activateProfileRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "activate_user_profile");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject();
            Grant grant = activateProfileRequest.getGrant();
            LogEntryBuilder.withGrant(builder, grant);
            builder.endObject();
            this.logEntry.with(LoggingAuditTrail.PUT_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(UpdateProfileDataRequest updateProfileDataRequest) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "update_user_profile_data");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject().field("uid", updateProfileDataRequest.getUid()).field("labels", updateProfileDataRequest.getLabels()).field("data", updateProfileDataRequest.getData()).endObject();
            this.logEntry.with(LoggingAuditTrail.PUT_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withRequestBody(SetProfileEnabledRequest setProfileEnabledRequest) throws IOException {
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            if (setProfileEnabledRequest.isEnabled()) {
                builder.startObject().startObject("enable").field("uid", setProfileEnabledRequest.getUid()).endObject().endObject();
                this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "change_enable_user_profile");
            } else {
                builder.startObject().startObject("disable").field("uid", setProfileEnabledRequest.getUid()).endObject().endObject();
                this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "change_disable_user_profile");
            }
            this.logEntry.with(LoggingAuditTrail.CHANGE_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        LogEntryBuilder withDeleteRole(String roleName) throws IOException {
            this.logEntry.with(LoggingAuditTrail.EVENT_ACTION_FIELD_NAME, "delete_role");
            XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
            builder.startObject().startObject("role").field("name", roleName).endObject().endObject();
            this.logEntry.with(LoggingAuditTrail.DELETE_CONFIG_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
            return this;
        }

        static void withGrant(XContentBuilder builder, Grant grant) throws IOException {
            builder.startObject("grant").field(LoggingAuditTrail.LOG_TYPE, grant.getType());
            if (grant.getUsername() != null) {
                builder.startObject("user").field("name", grant.getUsername()).field("has_password", grant.getPassword() != null).endObject();
            }
            if (grant.getAccessToken() != null) {
                builder.field("has_access_token", grant.getAccessToken() != null);
            }
            if (grant.getRunAsUsername() != null) {
                builder.field("run_as", grant.getRunAsUsername());
            }
            builder.endObject();
        }

        LogEntryBuilder withRestUriAndMethod(HttpPreRequest request) {
            int queryStringIndex = request.uri().indexOf(63);
            int queryStringLength = request.uri().indexOf(35);
            if (queryStringLength < 0) {
                queryStringLength = request.uri().length();
            }
            if (queryStringIndex < 0) {
                this.logEntry.with(LoggingAuditTrail.URL_PATH_FIELD_NAME, request.uri().substring(0, queryStringLength));
            } else {
                this.logEntry.with(LoggingAuditTrail.URL_PATH_FIELD_NAME, request.uri().substring(0, queryStringIndex));
            }
            if (queryStringIndex > -1) {
                this.logEntry.with(LoggingAuditTrail.URL_QUERY_FIELD_NAME, request.uri().substring(queryStringIndex + 1, queryStringLength));
            }
            this.logEntry.with(LoggingAuditTrail.REQUEST_METHOD_FIELD_NAME, request.method().toString());
            return this;
        }

        LogEntryBuilder withRunAsSubject(Authentication authentication) {
            Authentication.RealmRef lookedUpBy;
            ((StringMapMessage)((StringMapMessage)this.logEntry.with(LoggingAuditTrail.PRINCIPAL_FIELD_NAME, authentication.getAuthenticatingSubject().getUser().principal())).with(LoggingAuditTrail.PRINCIPAL_REALM_FIELD_NAME, authentication.getAuthenticatingSubject().getRealm().getName())).with(LoggingAuditTrail.PRINCIPAL_RUN_AS_FIELD_NAME, authentication.getEffectiveSubject().getUser().principal());
            if (authentication.getAuthenticatingSubject().getRealm().getDomain() != null) {
                this.logEntry.with(LoggingAuditTrail.PRINCIPAL_DOMAIN_FIELD_NAME, authentication.getAuthenticatingSubject().getRealm().getDomain().name());
            }
            Authentication.RealmRef realmRef = lookedUpBy = authentication.isRunAs() ? authentication.getEffectiveSubject().getRealm() : null;
            if (lookedUpBy != null) {
                this.logEntry.with(LoggingAuditTrail.PRINCIPAL_RUN_AS_REALM_FIELD_NAME, lookedUpBy.getName());
                if (lookedUpBy.getDomain() != null) {
                    this.logEntry.with(LoggingAuditTrail.PRINCIPAL_RUN_AS_DOMAIN_FIELD_NAME, lookedUpBy.getDomain().name());
                }
            }
            return this;
        }

        LogEntryBuilder withRestOrigin(ThreadContext threadContext) {
            assert (LoggingAuditTrail.LOCAL_ORIGIN_FIELD_VALUE.equals(this.logEntry.get(LoggingAuditTrail.ORIGIN_TYPE_FIELD_NAME)));
            InetSocketAddress restAddress = RemoteHostHeader.restRemoteAddress(threadContext);
            if (restAddress != null) {
                ((StringMapMessage)this.logEntry.with(LoggingAuditTrail.ORIGIN_TYPE_FIELD_NAME, LoggingAuditTrail.REST_ORIGIN_FIELD_VALUE)).with(LoggingAuditTrail.ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetSocketAddress)restAddress));
            }
            return this;
        }

        LogEntryBuilder withRestOrTransportOrigin(TransportRequest transportRequest, ThreadContext threadContext) {
            assert (LoggingAuditTrail.LOCAL_ORIGIN_FIELD_VALUE.equals(this.logEntry.get(LoggingAuditTrail.ORIGIN_TYPE_FIELD_NAME)));
            InetSocketAddress restAddress = RemoteHostHeader.restRemoteAddress(threadContext);
            if (restAddress != null) {
                ((StringMapMessage)this.logEntry.with(LoggingAuditTrail.ORIGIN_TYPE_FIELD_NAME, LoggingAuditTrail.REST_ORIGIN_FIELD_VALUE)).with(LoggingAuditTrail.ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetSocketAddress)restAddress));
            } else {
                InetSocketAddress address = transportRequest.remoteAddress();
                if (address != null) {
                    ((StringMapMessage)this.logEntry.with(LoggingAuditTrail.ORIGIN_TYPE_FIELD_NAME, LoggingAuditTrail.TRANSPORT_ORIGIN_FIELD_VALUE)).with(LoggingAuditTrail.ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetSocketAddress)address));
                }
            }
            return this;
        }

        LogEntryBuilder withRequestBody(RestRequest request) {
            String requestContent;
            if (LoggingAuditTrail.this.includeRequestBody && org.elasticsearch.common.Strings.hasLength((String)(requestContent = AuditUtil.restRequestContent(request)))) {
                this.logEntry.with(LoggingAuditTrail.REQUEST_BODY_FIELD_NAME, requestContent);
            }
            return this;
        }

        LogEntryBuilder withRequestId(String requestId) {
            if (requestId != null) {
                this.logEntry.with(LoggingAuditTrail.REQUEST_ID_FIELD_NAME, requestId);
            }
            return this;
        }

        LogEntryBuilder withThreadContext(ThreadContext threadContext) {
            this.setThreadContextField(threadContext, "X-Forwarded-For", LoggingAuditTrail.X_FORWARDED_FOR_FIELD_NAME);
            this.setThreadContextField(threadContext, "X-Opaque-Id", LoggingAuditTrail.OPAQUE_ID_FIELD_NAME);
            this.setThreadContextField(threadContext, LoggingAuditTrail.TRACE_ID_FIELD_NAME, LoggingAuditTrail.TRACE_ID_FIELD_NAME);
            return this;
        }

        private void setThreadContextField(ThreadContext threadContext, String threadContextFieldName, String auditLogFieldName) {
            String fieldValue = threadContext.getHeader(threadContextFieldName);
            if (fieldValue != null) {
                this.logEntry.with(auditLogFieldName, fieldValue);
            }
        }

        LogEntryBuilder withAuthentication(Authentication authentication) {
            LogEntryBuilder.addAuthenticationFieldsToLogEntry(this.logEntry, authentication);
            return this;
        }

        static void addAuthenticationFieldsToLogEntry(StringMapMessage logEntry, Authentication authentication) {
            logEntry.with(LoggingAuditTrail.PRINCIPAL_FIELD_NAME, authentication.getEffectiveSubject().getUser().principal());
            logEntry.with(LoggingAuditTrail.AUTHENTICATION_TYPE_FIELD_NAME, authentication.getAuthenticationType().toString());
            if (authentication.isApiKey() || authentication.isCrossClusterAccess()) {
                String creatorRealmName;
                logEntry.with(LoggingAuditTrail.API_KEY_ID_FIELD_NAME, (String)authentication.getAuthenticatingSubject().getMetadata().get("_security_api_key_id"));
                String apiKeyName = (String)authentication.getAuthenticatingSubject().getMetadata().get("_security_api_key_name");
                if (apiKeyName != null) {
                    logEntry.with(LoggingAuditTrail.API_KEY_NAME_FIELD_NAME, apiKeyName);
                }
                if ((creatorRealmName = ApiKeyService.getCreatorRealmName(authentication)) != null) {
                    logEntry.with(LoggingAuditTrail.PRINCIPAL_REALM_FIELD_NAME, creatorRealmName);
                }
                if (authentication.isCrossClusterAccess()) {
                    Authentication innerAuthentication = (Authentication)authentication.getAuthenticatingSubject().getMetadata().get("_security_cross_cluster_access_authentication");
                    StringMapMessage crossClusterAccessLogEntry = logEntry.newInstance(Collections.emptyMap());
                    LogEntryBuilder.addAuthenticationFieldsToLogEntry(crossClusterAccessLogEntry, innerAuthentication);
                    try {
                        XContentBuilder builder = JsonXContent.contentBuilder().humanReadable(true);
                        builder.map(crossClusterAccessLogEntry.getData());
                        logEntry.with(LoggingAuditTrail.CROSS_CLUSTER_ACCESS_FIELD_NAME, org.elasticsearch.common.Strings.toString((XContentBuilder)builder));
                    }
                    catch (IOException e) {
                        throw new ElasticsearchSecurityException("Unexpected error while serializing cross cluster access authentication data", (Exception)e, new Object[0]);
                    }
                }
            } else {
                Authentication.RealmRef authenticatedBy = authentication.getAuthenticatingSubject().getRealm();
                if (authentication.isRunAs()) {
                    Authentication.RealmRef lookedUpBy = authentication.getEffectiveSubject().getRealm();
                    if (lookedUpBy != null) {
                        logEntry.with(LoggingAuditTrail.PRINCIPAL_REALM_FIELD_NAME, lookedUpBy.getName());
                        if (lookedUpBy.getDomain() != null) {
                            logEntry.with(LoggingAuditTrail.PRINCIPAL_DOMAIN_FIELD_NAME, lookedUpBy.getDomain().name());
                        }
                    }
                    ((StringMapMessage)logEntry.with(LoggingAuditTrail.PRINCIPAL_RUN_BY_FIELD_NAME, authentication.getAuthenticatingSubject().getUser().principal())).with(LoggingAuditTrail.PRINCIPAL_RUN_BY_REALM_FIELD_NAME, authenticatedBy.getName());
                    if (authenticatedBy.getDomain() != null) {
                        logEntry.with(LoggingAuditTrail.PRINCIPAL_RUN_BY_DOMAIN_FIELD_NAME, authenticatedBy.getDomain().name());
                    }
                } else {
                    logEntry.with(LoggingAuditTrail.PRINCIPAL_REALM_FIELD_NAME, authenticatedBy.getName());
                    if (authenticatedBy.getDomain() != null) {
                        logEntry.with(LoggingAuditTrail.PRINCIPAL_DOMAIN_FIELD_NAME, authenticatedBy.getDomain().name());
                    }
                }
            }
            if (authentication.isServiceAccount()) {
                ((StringMapMessage)logEntry.with(LoggingAuditTrail.SERVICE_TOKEN_NAME_FIELD_NAME, (String)authentication.getAuthenticatingSubject().getMetadata().get("_token_name"))).with(LoggingAuditTrail.SERVICE_TOKEN_TYPE_FIELD_NAME, "_service_account_" + String.valueOf(authentication.getAuthenticatingSubject().getMetadata().get("_token_source")));
            }
        }

        LogEntryBuilder with(String key, String value) {
            if (value != null) {
                this.logEntry.with(key, value);
            }
            return this;
        }

        LogEntryBuilder with(String key, String[] values) {
            if (values != null) {
                this.logEntry.with(key, LogEntryBuilder.toQuotedJsonArray(values));
            }
            return this;
        }

        LogEntryBuilder with(Map<String, Object> map) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value.getClass().isArray()) {
                    this.logEntry.with(entry.getKey(), LogEntryBuilder.toQuotedJsonArray((Object[])value));
                    continue;
                }
                this.logEntry.with(entry.getKey(), value);
            }
            return this;
        }

        void build() {
            LoggingAuditTrail.this.logger.info(AUDIT_MARKER, (Message)this.logEntry);
        }

        static String toQuotedJsonArray(Object[] values) {
            assert (values != null);
            StringBuilder stringBuilder = new StringBuilder();
            JsonStringEncoder jsonStringEncoder = JsonStringEncoder.getInstance();
            stringBuilder.append("[");
            for (Object value : values) {
                if (value == null) continue;
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("\"");
                jsonStringEncoder.quoteAsString((CharSequence)value.toString(), stringBuilder);
                stringBuilder.append("\"");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    private static final class EventFilterPolicy {
        private final String name;
        private final Predicate<String> ignorePrincipalsPredicate;
        private final Predicate<String> ignoreRealmsPredicate;
        private final Predicate<String> ignoreRolesPredicate;
        private final Predicate<String> ignoreIndicesPredicate;
        private final Predicate<String> ignoreActionsPredicate;

        EventFilterPolicy(String name, Settings settings) {
            this.name = name;
            this.ignorePrincipalsPredicate = EventFilterPolicy.parsePredicate((List)FILTER_POLICY_IGNORE_PRINCIPALS.getConcreteSettingForNamespace(name).get(settings));
            this.ignoreRealmsPredicate = EventFilterPolicy.parsePredicate((List)FILTER_POLICY_IGNORE_REALMS.getConcreteSettingForNamespace(name).get(settings));
            this.ignoreRolesPredicate = EventFilterPolicy.parsePredicate((List)FILTER_POLICY_IGNORE_ROLES.getConcreteSettingForNamespace(name).get(settings));
            this.ignoreIndicesPredicate = EventFilterPolicy.parsePredicate((List)FILTER_POLICY_IGNORE_INDICES.getConcreteSettingForNamespace(name).get(settings));
            this.ignoreActionsPredicate = EventFilterPolicy.parsePredicate((List)FILTER_POLICY_IGNORE_ACTIONS.getConcreteSettingForNamespace(name).get(settings));
        }

        static Predicate<String> parsePredicate(List<String> l) {
            return Automatons.predicate(EventFilterPolicy.emptyStringBuildsEmptyAutomaton(l));
        }

        private static List<String> emptyStringBuildsEmptyAutomaton(List<String> l) {
            if (l.isEmpty()) {
                return Collections.singletonList("//");
            }
            return l.stream().map(f -> f.isEmpty() ? "//" : f).toList();
        }

        Predicate<AuditEventMetaInfo> ignorePredicate() {
            return eventInfo -> eventInfo.principal != null && this.ignorePrincipalsPredicate.test(eventInfo.principal) && eventInfo.realm != null && this.ignoreRealmsPredicate.test(eventInfo.realm) && eventInfo.action != null && this.ignoreActionsPredicate.test(eventInfo.action) && eventInfo.roles.get().allMatch(role -> role != null && this.ignoreRolesPredicate.test((String)role)) && eventInfo.indices.get().allMatch(index -> index != null && this.ignoreIndicesPredicate.test((String)index));
        }

        public String toString() {
            return "[users]:" + this.ignorePrincipalsPredicate.toString() + "&[realms]:" + this.ignoreRealmsPredicate.toString() + "&[roles]:" + this.ignoreRolesPredicate.toString() + "&[indices]:" + this.ignoreIndicesPredicate.toString() + "&[actions]:" + this.ignoreActionsPredicate.toString();
        }
    }
}

