/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.sp;

import java.time.Duration;
import java.util.List;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;

public final class ServiceProviderDefaults {
    public static final Setting<String> APPLICATION_NAME_SETTING = Setting.simpleString((String)"xpack.idp.privileges.application", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> NAMEID_FORMAT_SETTING = Setting.simpleString((String)"xpack.idp.defaults.nameid_format", (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:transient", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> AUTHN_EXPIRY_SETTING = Setting.timeSetting((String)"xpack.idp.defaults.authn_expiry", (TimeValue)TimeValue.timeValueMinutes((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public final String applicationName;
    public final String nameIdFormat;
    public final Duration authenticationExpiry;

    public ServiceProviderDefaults(String applicationName, String nameIdFormat, Duration authenticationExpiry) {
        this.applicationName = applicationName;
        this.nameIdFormat = nameIdFormat;
        this.authenticationExpiry = authenticationExpiry;
    }

    public static ServiceProviderDefaults forSettings(Settings settings) {
        String appplication = ServiceProviderDefaults.require(settings, APPLICATION_NAME_SETTING);
        String nameId = (String)NAMEID_FORMAT_SETTING.get(settings);
        TimeValue expiry = (TimeValue)AUTHN_EXPIRY_SETTING.get(settings);
        return new ServiceProviderDefaults(appplication, nameId, Duration.ofMillis(expiry.millis()));
    }

    private static <T> T require(Settings settings, Setting<T> setting) {
        if (setting.exists(settings)) {
            return (T)setting.get(settings);
        }
        throw new IllegalStateException("Setting [" + setting.getKey() + "] must be configured");
    }

    public static List<Setting<?>> getSettings() {
        return List.of(APPLICATION_NAME_SETTING, NAMEID_FORMAT_SETTING, AUTHN_EXPIRY_SETTING);
    }
}

