/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.scanner;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.core.PathUtils;
import org.objectweb.asm.ClassReader;

public class ClassReaders {
    private static final String MODULE_INFO = "module-info.class";

    public static List<ClassReader> ofDirWithJars(Path dir) {
        List<ClassReader> list;
        block9: {
            if (dir == null) {
                return Collections.emptyList();
            }
            Stream<Path> stream = Files.list(dir);
            try {
                list = ClassReaders.ofPaths(stream);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<ClassReader> ofPaths(Set<URL> classpathFiles) {
        return ClassReaders.ofPaths(classpathFiles.stream().map(ClassReaders::toPath));
    }

    private static Path toPath(URL url) {
        try {
            return PathUtils.get((URI)url.toURI());
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static List<ClassReader> ofPaths(Stream<Path> list) {
        return list.filter(x$0 -> Files.exists(x$0, new LinkOption[0])).flatMap(p -> {
            if (p.toString().endsWith(".jar")) {
                return ClassReaders.classesInJar(p).stream();
            }
            return ClassReaders.classesInPath(p).stream();
        }).toList();
    }

    private static List<ClassReader> classesInJar(Path jar) {
        List<ClassReader> list;
        block8: {
            FileSystem jarFs = FileSystems.newFileSystem(jar);
            try {
                Path root = jarFs.getPath("/", new String[0]);
                list = ClassReaders.classesInPath(root);
                if (jarFs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jarFs != null) {
                        try {
                            jarFs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            jarFs.close();
        }
        return list;
    }

    private static List<ClassReader> classesInPath(Path root) {
        List<ClassReader> list;
        block8: {
            Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);
            try {
                list = stream.filter(p -> p.toString().endsWith(".class")).filter(p -> !p.toString().endsWith(MODULE_INFO)).filter(p -> !p.toString().startsWith("/META-INF")).map(p -> {
                    ClassReader classReader;
                    block8: {
                        InputStream is = Files.newInputStream(p, new OpenOption[0]);
                        try {
                            byte[] classBytes = is.readAllBytes();
                            classReader = new ClassReader(classBytes);
                            if (is == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException ex) {
                                throw new UncheckedIOException(ex);
                            }
                        }
                        is.close();
                    }
                    return classReader;
                }).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<ClassReader> ofClassPath() throws IOException {
        String classpath = System.getProperty("java.class.path");
        return ClassReaders.ofClassPath(classpath);
    }

    public static List<ClassReader> ofClassPath(String classpath) {
        if (classpath != null && !classpath.equals("")) {
            String classpathSeparator = System.getProperty("path.separator");
            String[] pathelements = classpath.split(classpathSeparator);
            return ClassReaders.ofPaths(Arrays.stream(pathelements).map(x$0 -> Paths.get(x$0, new String[0])));
        }
        return Collections.emptyList();
    }
}

