/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.CartesianBoundsAggregatorBase;
import org.elasticsearch.xpack.spatial.search.aggregations.support.CartesianPointValuesSource;

public final class CartesianBoundsAggregator
extends CartesianBoundsAggregatorBase {
    private final CartesianPointValuesSource valuesSource;

    public CartesianBoundsAggregator(String name, AggregationContext context, Aggregator parent, ValuesSourceConfig valuesSourceConfig, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (CartesianPointValuesSource)valuesSourceConfig.getValuesSource();
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) {
        final CartesianPointValuesSource.MultiCartesianPointValues values = this.valuesSource.pointValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, (Object)values){

            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    CartesianBoundsAggregator.this.maybeResize(bucket);
                    int valuesCount = values.docValueCount();
                    for (int i = 0; i < valuesCount; ++i) {
                        CartesianPoint value = values.nextValue();
                        CartesianBoundsAggregator.this.addBounds(bucket, value.getY(), value.getY(), value.getX(), value.getX());
                    }
                }
            }
        };
    }
}

