/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.task;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record ReindexDataStreamEnrichedStatus(long persistentTaskStartTime, int totalIndices, int totalIndicesToBeUpgraded, boolean complete, Exception exception, Map<String, Tuple<Long, Long>> inProgress, int pending, List<Tuple<String, Exception>> errors) implements ToXContentObject,
Writeable
{
    public ReindexDataStreamEnrichedStatus {
        Objects.requireNonNull(inProgress);
        Objects.requireNonNull(errors);
    }

    public ReindexDataStreamEnrichedStatus(StreamInput in) throws IOException {
        this(in.readLong(), in.readInt(), in.readInt(), in.readBoolean(), in.readException(), in.readMap(StreamInput::readString, in2 -> Tuple.tuple((Object)in2.readLong(), (Object)in2.readLong())), in.readInt(), in.readCollectionAsList(in1 -> Tuple.tuple((Object)in1.readString(), (Object)in1.readException())));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.persistentTaskStartTime);
        out.writeInt(this.totalIndices);
        out.writeInt(this.totalIndicesToBeUpgraded);
        out.writeBoolean(this.complete);
        out.writeException((Throwable)this.exception);
        out.writeMap(this.inProgress, StreamOutput::writeString, (out2, tuple) -> {
            out2.writeLong(((Long)tuple.v1()).longValue());
            out2.writeLong(((Long)tuple.v2()).longValue());
        });
        out.writeInt(this.pending);
        out.writeCollection(this.errors, (out1, tuple) -> {
            out1.writeString((String)tuple.v1());
            out1.writeException((Throwable)tuple.v2());
        });
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.timestampFieldsFromUnixEpochMillis("start_time_millis", "start_time", this.persistentTaskStartTime);
        builder.field("complete", this.complete);
        builder.field("total_indices_in_data_stream", this.totalIndices);
        builder.field("total_indices_requiring_upgrade", this.totalIndicesToBeUpgraded);
        builder.field("successes", this.totalIndicesToBeUpgraded - (this.inProgress.size() + this.pending + this.errors.size()));
        builder.startArray("in_progress");
        for (Map.Entry<String, Tuple<Long, Long>> entry : this.inProgress.entrySet()) {
            builder.startObject();
            builder.field("index", entry.getKey());
            builder.field("total_doc_count", (Long)entry.getValue().v1());
            builder.field("reindexed_doc_count", (Long)entry.getValue().v2());
            builder.endObject();
        }
        builder.endArray();
        builder.field("pending", this.pending);
        builder.startArray("errors");
        for (Tuple tuple : this.errors) {
            builder.startObject();
            builder.field("index", (String)tuple.v1());
            builder.field("message", tuple.v2() == null ? "unknown" : ((Exception)tuple.v2()).getMessage());
            builder.endObject();
        }
        builder.endArray();
        if (this.exception != null) {
            builder.field("exception", this.exception.getMessage());
        }
        builder.endObject();
        return builder;
    }
}

