/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.symbol;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.node.ANode;
import org.elasticsearch.painless.symbol.Decorator;
import org.elasticsearch.painless.symbol.ScriptScope;

public abstract class SemanticScope {
    protected final ScriptScope scriptScope;
    protected final Map<String, Variable> variables = new HashMap<String, Variable>();
    protected final Set<String> usedVariables;

    public static FunctionScope newFunctionScope(ScriptScope scriptScope, Class<?> returnType) {
        return new FunctionScope(scriptScope, returnType);
    }

    protected SemanticScope(ScriptScope scriptScope, Set<String> usedVariables) {
        this.scriptScope = Objects.requireNonNull(scriptScope);
        this.usedVariables = Objects.requireNonNull(usedVariables);
    }

    public LambdaScope newLambdaScope(Class<?> returnType) {
        return new LambdaScope(this, returnType);
    }

    public BlockScope newLocalScope() {
        return new BlockScope(this);
    }

    public ScriptScope getScriptScope() {
        return this.scriptScope;
    }

    public <T extends Decorator.Decoration> T putDecoration(ANode node, T decoration) {
        return this.scriptScope.put(node.getIdentifier(), decoration);
    }

    public <T extends Decorator.Decoration> T removeDecoration(ANode node, Class<T> type) {
        return this.scriptScope.remove(node.getIdentifier(), type);
    }

    public <T extends Decorator.Decoration> T getDecoration(ANode node, Class<T> type) {
        return this.scriptScope.get(node.getIdentifier(), type);
    }

    public boolean hasDecoration(ANode node, Class<? extends Decorator.Decoration> type) {
        return this.scriptScope.has(node.getIdentifier(), type);
    }

    public <T extends Decorator.Decoration> boolean copyDecoration(ANode originalNode, ANode targetNode, Class<T> type) {
        return this.scriptScope.copy(originalNode.getIdentifier(), targetNode.getIdentifier(), type);
    }

    public boolean setCondition(ANode node, Class<? extends Decorator.Condition> type) {
        return this.scriptScope.set(node.getIdentifier(), type);
    }

    public boolean deleteCondition(ANode node, Class<? extends Decorator.Condition> type) {
        return this.scriptScope.delete(node.getIdentifier(), type);
    }

    public boolean getCondition(ANode node, Class<? extends Decorator.Condition> type) {
        return this.scriptScope.exists(node.getIdentifier(), type);
    }

    public boolean replicateCondition(ANode originalNode, ANode targetNode, Class<? extends Decorator.Condition> type) {
        return this.scriptScope.replicate(originalNode.getIdentifier(), targetNode.getIdentifier(), type);
    }

    public abstract Class<?> getReturnType();

    public abstract String getReturnCanonicalTypeName();

    public Variable defineVariable(Location location, Class<?> type, String name, boolean isReadOnly) {
        if (this.isVariableDefined(name)) {
            throw location.createError(new IllegalArgumentException("variable [" + name + "] is already defined"));
        }
        Variable variable = new Variable(type, name, isReadOnly);
        this.variables.put(name, variable);
        return variable;
    }

    public abstract boolean isVariableDefined(String var1);

    public abstract Variable getVariable(Location var1, String var2);

    public void setUsesInstanceMethod() {
    }

    public boolean usesInstanceMethod() {
        return false;
    }

    public Variable defineInternalVariable(Location location, Class<?> type, String name, boolean isReadOnly) {
        return this.defineVariable(location, type, "#" + name, isReadOnly);
    }

    public boolean isInternalVariableDefined(String name) {
        return this.isVariableDefined("#" + name);
    }

    public Variable getInternalVariable(Location location, String name) {
        return this.getVariable(location, "#" + name);
    }

    public Set<String> getUsedVariables() {
        return Collections.unmodifiableSet(this.usedVariables);
    }

    public static class FunctionScope
    extends SemanticScope {
        protected final Class<?> returnType;

        public FunctionScope(ScriptScope scriptScope, Class<?> returnType) {
            super(scriptScope, new HashSet<String>());
            this.returnType = Objects.requireNonNull(returnType);
        }

        @Override
        public boolean isVariableDefined(String name) {
            return this.variables.containsKey(name);
        }

        @Override
        public Variable getVariable(Location location, String name) {
            Objects.requireNonNull(location);
            Objects.requireNonNull(name);
            Variable variable = (Variable)this.variables.get(name);
            if (variable == null) {
                throw location.createError(new IllegalArgumentException("variable [" + name + "] is not defined"));
            }
            this.usedVariables.add(name);
            return variable;
        }

        @Override
        public Class<?> getReturnType() {
            return this.returnType;
        }

        @Override
        public String getReturnCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.returnType);
        }
    }

    public static class LambdaScope
    extends SemanticScope {
        protected final SemanticScope parent;
        protected final Class<?> returnType;
        protected final Set<Variable> captures = new HashSet<Variable>();
        protected boolean usesInstanceMethod = false;

        protected LambdaScope(SemanticScope parent, Class<?> returnType) {
            super(parent.scriptScope, parent.usedVariables);
            this.parent = parent;
            this.returnType = returnType;
        }

        @Override
        public boolean isVariableDefined(String name) {
            if (this.variables.containsKey(name)) {
                return true;
            }
            return this.parent.isVariableDefined(name);
        }

        @Override
        public Variable getVariable(Location location, String name) {
            Objects.requireNonNull(location);
            Objects.requireNonNull(name);
            Variable variable = (Variable)this.variables.get(name);
            if (variable == null) {
                variable = this.parent.getVariable(location, name);
                variable = new Variable(variable.type(), variable.name(), true);
                this.captures.add(variable);
            } else {
                this.usedVariables.add(name);
            }
            return variable;
        }

        @Override
        public Class<?> getReturnType() {
            return this.returnType;
        }

        @Override
        public String getReturnCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.returnType);
        }

        public Set<Variable> getCaptures() {
            return Collections.unmodifiableSet(this.captures);
        }

        @Override
        public void setUsesInstanceMethod() {
            if (this.usesInstanceMethod) {
                return;
            }
            this.usesInstanceMethod = true;
            if (this.parent != null) {
                this.parent.setUsesInstanceMethod();
            }
        }

        @Override
        public boolean usesInstanceMethod() {
            return this.usesInstanceMethod;
        }
    }

    public static class BlockScope
    extends SemanticScope {
        protected final SemanticScope parent;

        protected BlockScope(SemanticScope parent) {
            super(parent.scriptScope, parent.usedVariables);
            this.parent = parent;
        }

        @Override
        public boolean isVariableDefined(String name) {
            if (this.variables.containsKey(name)) {
                return true;
            }
            return this.parent.isVariableDefined(name);
        }

        @Override
        public Variable getVariable(Location location, String name) {
            Objects.requireNonNull(location);
            Objects.requireNonNull(name);
            Variable variable = (Variable)this.variables.get(name);
            if (variable == null) {
                variable = this.parent.getVariable(location, name);
            } else {
                this.usedVariables.add(name);
            }
            return variable;
        }

        @Override
        public Class<?> getReturnType() {
            return this.parent.getReturnType();
        }

        @Override
        public String getReturnCanonicalTypeName() {
            return this.parent.getReturnCanonicalTypeName();
        }

        @Override
        public void setUsesInstanceMethod() {
            this.parent.setUsesInstanceMethod();
        }
    }

    public record Variable(Class<?> type, String name, boolean isFinal) {
        public Variable {
            Objects.requireNonNull(type);
            Objects.requireNonNull(name);
        }

        public String getCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.type);
        }
    }
}

