/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldMapper;

class TimeseriesFieldTypeHelper {
    private final MapperService mapperService;
    private final String timestampField;

    private TimeseriesFieldTypeHelper(MapperService mapperService, String timestampField) {
        this.mapperService = mapperService;
        this.timestampField = timestampField;
    }

    public boolean isTimeSeriesLabel(String field, Map<String, ?> unused) {
        MappingLookup lookup = this.mapperService.mappingLookup();
        MappedFieldType fieldType = lookup.getFieldType(field);
        return fieldType != null && !this.timestampField.equals(field) && fieldType.isAggregatable() && !fieldType.isDimension() && !this.mapperService.isMetadataField(field);
    }

    public boolean isTimeSeriesMetric(String unused, Map<String, ?> fieldMapping) {
        String metricType = (String)fieldMapping.get("time_series_metric");
        return metricType != null && List.of(TimeSeriesParams.MetricType.values()).contains(TimeSeriesParams.MetricType.fromString((String)metricType));
    }

    public boolean isTimeSeriesDimension(String unused, Map<String, ?> fieldMapping) {
        return Boolean.TRUE.equals(fieldMapping.get("time_series_dimension"));
    }

    public List<String> extractFlattenedDimensions(String field, Map<String, ?> fieldMapping) {
        Mapper mapper = this.mapperService.mappingLookup().getMapper(field);
        if (!(mapper instanceof FlattenedFieldMapper)) {
            return null;
        }
        Object dimensions = fieldMapping.get("time_series_dimensions");
        if (dimensions instanceof List) {
            List actualList = (List)dimensions;
            return actualList.stream().map(field_in_flattened -> field + "." + String.valueOf(field_in_flattened)).toList();
        }
        return null;
    }

    static class Builder {
        private final MapperService mapperService;

        Builder(MapperService mapperService) {
            this.mapperService = mapperService;
        }

        public TimeseriesFieldTypeHelper build(String timestampField) throws IOException {
            return new TimeseriesFieldTypeHelper(this.mapperService, timestampField);
        }
    }
}

