/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.DownsampleFieldSerializer;
import org.elasticsearch.xpack.downsample.LabelFieldProducer;
import org.elasticsearch.xpack.downsample.MetricFieldProducer;

final class AggregateMetricFieldSerializer
implements DownsampleFieldSerializer {
    private final Collection<AbstractDownsampleFieldProducer> producers;
    private final String name;

    AggregateMetricFieldSerializer(String name, Collection<AbstractDownsampleFieldProducer> producers) {
        this.name = name;
        this.producers = producers;
    }

    @Override
    public void write(XContentBuilder builder) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        builder.startObject(this.name);
        for (AbstractDownsampleFieldProducer fieldProducer : this.producers) {
            LabelFieldProducer labelFieldProducer;
            LabelFieldProducer.Label label;
            assert (this.name.equals(fieldProducer.name())) : "producer has a different name";
            if (fieldProducer.isEmpty()) continue;
            if (fieldProducer instanceof MetricFieldProducer) {
                MetricFieldProducer metricFieldProducer = (MetricFieldProducer)fieldProducer;
                if (metricFieldProducer instanceof MetricFieldProducer.GaugeMetricFieldProducer) {
                    MetricFieldProducer.GaugeMetricFieldProducer gaugeProducer = (MetricFieldProducer.GaugeMetricFieldProducer)metricFieldProducer;
                    builder.field("max", gaugeProducer.max);
                    builder.field("min", gaugeProducer.min);
                    builder.field("sum", gaugeProducer.sum.value());
                    builder.field("value_count", gaugeProducer.count);
                    continue;
                }
                if (metricFieldProducer instanceof MetricFieldProducer.CounterMetricFieldProducer) {
                    MetricFieldProducer.CounterMetricFieldProducer counterProducer = (MetricFieldProducer.CounterMetricFieldProducer)metricFieldProducer;
                    builder.field("last_value", counterProducer.lastValue);
                    continue;
                }
                if (metricFieldProducer instanceof MetricFieldProducer.AggregatedGaugeMetricFieldProducer) {
                    MetricFieldProducer.AggregatedGaugeMetricFieldProducer producer = (MetricFieldProducer.AggregatedGaugeMetricFieldProducer)metricFieldProducer;
                    switch (producer.metric) {
                        case max: {
                            builder.field("max", producer.max);
                            break;
                        }
                        case min: {
                            builder.field("min", producer.min);
                            break;
                        }
                        case sum: {
                            builder.field("sum", producer.sum.value());
                            break;
                        }
                        case value_count: {
                            builder.field("value_count", producer.count);
                        }
                    }
                    continue;
                }
                throw new IllegalStateException();
            }
            if (!(fieldProducer instanceof LabelFieldProducer) || (label = (labelFieldProducer = (LabelFieldProducer)fieldProducer).label()).get() == null) continue;
            builder.field(label.name(), label.get());
        }
        builder.endObject();
    }

    private boolean isEmpty() {
        for (AbstractDownsampleFieldProducer p : this.producers) {
            if (p.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

