/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.action;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.admin.indices.rollover.RolloverInfo;
import org.elasticsearch.action.datastreams.lifecycle.ExplainDataStreamLifecycleAction;
import org.elasticsearch.action.datastreams.lifecycle.ExplainIndexDataStreamLifecycle;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionSettings;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.datastreams.lifecycle.DataStreamLifecycleErrorStore;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportExplainDataStreamLifecycleAction
extends TransportMasterNodeReadAction<ExplainDataStreamLifecycleAction.Request, ExplainDataStreamLifecycleAction.Response> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final DataStreamLifecycleErrorStore errorStore;
    private final DataStreamGlobalRetentionSettings globalRetentionSettings;

    @Inject
    public TransportExplainDataStreamLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DataStreamLifecycleErrorStore dataLifecycleServiceErrorStore, DataStreamGlobalRetentionSettings globalRetentionSettings) {
        super(ExplainDataStreamLifecycleAction.INSTANCE.name(), transportService, clusterService, threadPool, actionFilters, ExplainDataStreamLifecycleAction.Request::new, ExplainDataStreamLifecycleAction.Response::new, (Executor)threadPool.executor("management"));
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.errorStore = dataLifecycleServiceErrorStore;
        this.globalRetentionSettings = globalRetentionSettings;
    }

    protected void masterOperation(Task task, ExplainDataStreamLifecycleAction.Request request, ClusterState state, ActionListener<ExplainDataStreamLifecycleAction.Response> listener) throws Exception {
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request);
        ArrayList<ExplainIndexDataStreamLifecycle> explainIndices = new ArrayList<ExplainIndexDataStreamLifecycle>(concreteIndices.length);
        Metadata metadata = state.metadata();
        for (String index : concreteIndices) {
            DataStream parentDataStream;
            IndexMetadata idxMetadata;
            block4: {
                block3: {
                    IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(index);
                    if (indexAbstraction == null || (idxMetadata = metadata.index(index)) == null) continue;
                    parentDataStream = indexAbstraction.getParentDataStream();
                    if (parentDataStream == null) break block3;
                    if (parentDataStream.isIndexManagedByDataStreamLifecycle(idxMetadata.getIndex(), arg_0 -> ((Metadata)metadata).index(arg_0))) break block4;
                }
                explainIndices.add(new ExplainIndexDataStreamLifecycle(index, false, false, null, null, null, null, null));
                continue;
            }
            RolloverInfo rolloverInfo = (RolloverInfo)idxMetadata.getRolloverInfos().get(parentDataStream.getName());
            TimeValue generationDate = parentDataStream.getGenerationLifecycleDate(idxMetadata);
            ExplainIndexDataStreamLifecycle explainIndexDataStreamLifecycle = new ExplainIndexDataStreamLifecycle(index, true, parentDataStream.isInternal(), Long.valueOf(idxMetadata.getCreationDate()), rolloverInfo == null ? null : Long.valueOf(rolloverInfo.getTime()), generationDate, parentDataStream.getLifecycle(), this.errorStore.getError(index));
            explainIndices.add(explainIndexDataStreamLifecycle);
        }
        ClusterSettings clusterSettings = this.clusterService.getClusterSettings();
        listener.onResponse((Object)new ExplainDataStreamLifecycleAction.Response(explainIndices, request.includeDefaults() ? (RolloverConfiguration)clusterSettings.get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING) : null, this.globalRetentionSettings.get()));
    }

    protected ClusterBlockException checkBlock(ExplainDataStreamLifecycleAction.Request request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request));
    }
}

