/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.datastreams.lifecycle.ErrorEntry;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.health.node.DslErrorInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class DataStreamLifecycleErrorStore {
    public static final int MAX_ERROR_MESSAGE_LENGTH = 1000;
    private final ConcurrentMap<String, ErrorEntry> indexNameToError = new ConcurrentHashMap<String, ErrorEntry>();
    private final LongSupplier nowSupplier;

    public DataStreamLifecycleErrorStore(LongSupplier nowSupplier) {
        this.nowSupplier = nowSupplier;
    }

    @Nullable
    public ErrorEntry recordError(String indexName, Exception e) {
        String exceptionToString = Strings.toString((builder, params) -> {
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (Throwable)e);
            return builder;
        });
        String newError = Strings.substring((String)exceptionToString, (int)0, (int)1000);
        ErrorEntry existingError = (ErrorEntry)this.indexNameToError.get(indexName);
        long recordedTimestamp = this.nowSupplier.getAsLong();
        if (existingError == null) {
            this.indexNameToError.put(indexName, new ErrorEntry(recordedTimestamp, newError, recordedTimestamp, 0));
        } else if (existingError.error().equals(newError)) {
            this.indexNameToError.put(indexName, ErrorEntry.incrementRetryCount((ErrorEntry)existingError, (LongSupplier)this.nowSupplier));
        } else {
            this.indexNameToError.put(indexName, new ErrorEntry(recordedTimestamp, newError, recordedTimestamp, 0));
        }
        return existingError;
    }

    public void clearRecordedError(String indexName) {
        this.indexNameToError.remove(indexName);
    }

    public void clearStore() {
        this.indexNameToError.clear();
    }

    @Nullable
    public ErrorEntry getError(String indexName) {
        return (ErrorEntry)this.indexNameToError.get(indexName);
    }

    public Set<String> getAllIndices() {
        return Set.copyOf(this.indexNameToError.keySet());
    }

    public List<DslErrorInfo> getErrorsInfo(Predicate<ErrorEntry> errorEntryPredicate, int limit) {
        if (this.indexNameToError.isEmpty()) {
            return List.of();
        }
        return this.indexNameToError.entrySet().stream().filter(keyValue -> errorEntryPredicate.test((ErrorEntry)keyValue.getValue())).sorted(Map.Entry.comparingByValue()).limit(limit).map(keyValue -> new DslErrorInfo((String)keyValue.getKey(), ((ErrorEntry)keyValue.getValue()).firstOccurrenceTimestamp(), ((ErrorEntry)keyValue.getValue()).retryCount())).collect(Collectors.toList());
    }
}

