/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Base64;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Transition;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.plugins.FieldPredicate;

class AutomatonFieldPredicate
implements FieldPredicate {
    private final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(AutomatonFieldPredicate.class);
    private final String automatonHash;
    private final CharacterRunAutomaton automaton;

    AutomatonFieldPredicate(Automaton originalAutomaton, CharacterRunAutomaton automaton) {
        this.automatonHash = AutomatonFieldPredicate.sha256(originalAutomaton);
        this.automaton = automaton;
    }

    public boolean test(String field) {
        return this.automaton.run(field);
    }

    public String modifyHash(String hash) {
        return hash + ":" + this.automatonHash;
    }

    public long ramBytesUsed() {
        return this.SHALLOW_SIZE + RamUsageEstimator.sizeOf((String)this.automatonHash);
    }

    private static String sha256(Automaton automaton) {
        MessageDigest messageDigest = MessageDigests.sha256();
        try {
            OutputStreamStreamOutput out = new OutputStreamStreamOutput((OutputStream)new DigestOutputStream(Streams.NULL_OUTPUT_STREAM, messageDigest));
            Transition t = new Transition();
            for (int state = 0; state < automaton.getNumStates(); ++state) {
                out.writeInt(state);
                out.writeBoolean(automaton.isAccept(state));
                int numTransitions = automaton.initTransition(state, t);
                for (int i = 0; i < numTransitions; ++i) {
                    automaton.getNextTransition(t);
                    out.writeInt(t.dest);
                    out.writeInt(t.min);
                    out.writeInt(t.max);
                }
            }
        }
        catch (IOException bogus) {
            throw new Error(bogus);
        }
        return Base64.getEncoder().encodeToString(messageDigest.digest());
    }
}

