/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.accesscontrol;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CachedSupplier;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.core.security.authz.permission.DocumentPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.support.SecurityQueryTemplateEvaluator;
import org.elasticsearch.xpack.core.security.support.CacheKey;

public class IndicesAccessControl {
    public static final IndicesAccessControl ALLOW_NO_INDICES = new IndicesAccessControl(true, Collections.singletonMap("-*", IndexAccessControl.ALLOW_ALL));
    public static final IndicesAccessControl DENIED = new IndicesAccessControl(false, Collections.emptyMap());
    private final boolean granted;
    private final CachedSupplier<Map<String, IndexAccessControl>> indexPermissionsSupplier;

    public IndicesAccessControl(boolean granted, Map<String, IndexAccessControl> indexPermissions) {
        this(granted, () -> Objects.requireNonNull(indexPermissions));
    }

    public IndicesAccessControl(boolean granted, Supplier<Map<String, IndexAccessControl>> indexPermissionsSupplier) {
        this.granted = granted;
        this.indexPermissionsSupplier = CachedSupplier.wrap(Objects.requireNonNull(indexPermissionsSupplier));
    }

    protected IndicesAccessControl(IndicesAccessControl copy) {
        this(copy.granted, (Supplier<Map<String, IndexAccessControl>>)copy.indexPermissionsSupplier);
    }

    @Nullable
    public IndexAccessControl getIndexPermissions(String index) {
        Tuple indexAndSelector = IndexNameExpressionResolver.splitSelectorExpression((String)index);
        return this.getAllIndexPermissions().get(indexAndSelector.v1());
    }

    public boolean hasIndexPermissions(String index) {
        return this.getIndexPermissions(index) != null;
    }

    public boolean isGranted() {
        return this.granted;
    }

    public DlsFlsUsage getFieldAndDocumentLevelSecurityUsage() {
        boolean hasFls = false;
        boolean hasDls = false;
        for (IndexAccessControl iac : this.getAllIndexPermissions().values()) {
            if (iac.fieldPermissions.hasFieldLevelSecurity()) {
                hasFls = true;
            }
            if (iac.documentPermissions.hasDocumentLevelPermissions()) {
                hasDls = true;
            }
            if (!hasFls || !hasDls) continue;
            return DlsFlsUsage.BOTH;
        }
        if (hasFls) {
            return DlsFlsUsage.FLS;
        }
        if (hasDls) {
            return DlsFlsUsage.DLS;
        }
        return DlsFlsUsage.NONE;
    }

    public List<String> getIndicesWithFieldOrDocumentLevelSecurity() {
        return this.getIndexNames(iac -> iac.fieldPermissions.hasFieldLevelSecurity() || iac.documentPermissions.hasDocumentLevelPermissions());
    }

    public List<String> getIndicesWithFieldLevelSecurity() {
        return this.getIndexNames(iac -> iac.fieldPermissions.hasFieldLevelSecurity());
    }

    public List<String> getIndicesWithDocumentLevelSecurity() {
        return this.getIndexNames(iac -> iac.documentPermissions.hasDocumentLevelPermissions());
    }

    private List<String> getIndexNames(Predicate<IndexAccessControl> predicate) {
        return this.getAllIndexPermissions().entrySet().stream().filter(entry -> predicate.test((IndexAccessControl)entry.getValue())).map(Map.Entry::getKey).toList();
    }

    private Map<String, IndexAccessControl> getAllIndexPermissions() {
        return (Map)this.indexPermissionsSupplier.get();
    }

    public IndicesAccessControl limitIndicesAccessControl(IndicesAccessControl limitedByIndicesAccessControl) {
        if (this instanceof AllowAllIndicesAccessControl) {
            return limitedByIndicesAccessControl;
        }
        if (limitedByIndicesAccessControl instanceof AllowAllIndicesAccessControl) {
            return this;
        }
        boolean isGranted = this.granted == limitedByIndicesAccessControl.granted ? this.granted : false;
        Supplier<Map<String, IndexAccessControl>> limitedIndexPermissions = () -> {
            Set<String> indexes = this.getAllIndexPermissions().keySet();
            Set<String> otherIndexes = limitedByIndicesAccessControl.getAllIndexPermissions().keySet();
            Set commonIndexes = Sets.intersection(indexes, otherIndexes);
            Map indexPermissionsMap = Maps.newMapWithExpectedSize((int)commonIndexes.size());
            for (String index : commonIndexes) {
                IndexAccessControl indexAccessControl = this.getIndexPermissions(index);
                IndexAccessControl limitedByIndexAccessControl = limitedByIndicesAccessControl.getIndexPermissions(index);
                indexPermissionsMap.put(index, indexAccessControl.limitIndexAccessControl(limitedByIndexAccessControl));
            }
            return indexPermissionsMap;
        };
        return new IndicesAccessControl(isGranted, limitedIndexPermissions);
    }

    public String toString() {
        return "IndicesAccessControl{granted=" + this.granted + ", indexPermissions=" + String.valueOf(this.indexPermissionsSupplier.get()) + "}";
    }

    public static IndicesAccessControl allowAll() {
        return AllowAllIndicesAccessControl.INSTANCE;
    }

    public static class IndexAccessControl
    implements CacheKey {
        public static final IndexAccessControl ALLOW_ALL = new IndexAccessControl(null, null);
        private final FieldPermissions fieldPermissions;
        private final DocumentPermissions documentPermissions;

        public IndexAccessControl(FieldPermissions fieldPermissions, DocumentPermissions documentPermissions) {
            this.fieldPermissions = fieldPermissions == null ? FieldPermissions.DEFAULT : fieldPermissions;
            this.documentPermissions = documentPermissions == null ? DocumentPermissions.allowAll() : documentPermissions;
        }

        public FieldPermissions getFieldPermissions() {
            return this.fieldPermissions;
        }

        public DocumentPermissions getDocumentPermissions() {
            return this.documentPermissions;
        }

        public IndexAccessControl limitIndexAccessControl(IndexAccessControl limitedByIndexAccessControl) {
            FieldPermissions constrainedFieldPermissions = this.getFieldPermissions().limitFieldPermissions(limitedByIndexAccessControl.fieldPermissions);
            DocumentPermissions constrainedDocumentPermissions = this.getDocumentPermissions().limitDocumentPermissions(limitedByIndexAccessControl.getDocumentPermissions());
            return new IndexAccessControl(constrainedFieldPermissions, constrainedDocumentPermissions);
        }

        public String toString() {
            return "IndexAccessControl{fieldPermissions=" + String.valueOf(this.fieldPermissions) + ", documentPermissions=" + String.valueOf(this.documentPermissions) + "}";
        }

        @Override
        public void buildCacheKey(StreamOutput out, SecurityQueryTemplateEvaluator.DlsQueryEvaluationContext context) throws IOException {
            if (this.documentPermissions.hasDocumentLevelPermissions()) {
                out.writeBoolean(true);
                this.documentPermissions.buildCacheKey(out, context);
            } else {
                out.writeBoolean(false);
            }
            if (this.fieldPermissions.hasFieldLevelSecurity()) {
                out.writeBoolean(true);
                this.fieldPermissions.buildCacheKey(out, context);
            } else {
                out.writeBoolean(false);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexAccessControl that = (IndexAccessControl)o;
            return Objects.equals(this.fieldPermissions, that.fieldPermissions) && Objects.equals(this.documentPermissions, that.documentPermissions);
        }

        public int hashCode() {
            return Objects.hash(this.fieldPermissions, this.documentPermissions);
        }
    }

    public static enum DlsFlsUsage {
        NONE,
        DLS{

            @Override
            public boolean hasDocumentLevelSecurity() {
                return true;
            }
        }
        ,
        FLS{

            @Override
            public boolean hasFieldLevelSecurity() {
                return true;
            }
        }
        ,
        BOTH{

            @Override
            public boolean hasFieldLevelSecurity() {
                return true;
            }

            @Override
            public boolean hasDocumentLevelSecurity() {
                return true;
            }
        };


        public boolean hasFieldLevelSecurity() {
            return false;
        }

        public boolean hasDocumentLevelSecurity() {
            return false;
        }
    }

    private static class AllowAllIndicesAccessControl
    extends IndicesAccessControl {
        private static final IndicesAccessControl INSTANCE = new AllowAllIndicesAccessControl();

        private AllowAllIndicesAccessControl() {
            super(true, Map.of());
        }

        @Override
        public IndexAccessControl getIndexPermissions(String index) {
            return IndexAccessControl.ALLOW_ALL;
        }

        @Override
        public String toString() {
            return "AllowAllIndicesAccessControl{}";
        }
    }
}

