/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Optional;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.AbstractTokenizationUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RobertaTokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class RobertaTokenizationUpdate
extends AbstractTokenizationUpdate {
    public static final ParseField NAME = new ParseField("roberta", new String[0]);
    public static final ConstructingObjectParser<RobertaTokenizationUpdate, Void> PARSER = new ConstructingObjectParser("roberta_tokenization_update", a -> new RobertaTokenizationUpdate(a[0] == null ? null : Tokenization.Truncate.fromString((String)a[0]), (Integer)a[1]));

    public static RobertaTokenizationUpdate fromXContent(XContentParser parser) {
        return (RobertaTokenizationUpdate)PARSER.apply(parser, null);
    }

    public RobertaTokenizationUpdate(@Nullable Tokenization.Truncate truncate, @Nullable Integer span) {
        super(truncate, span);
    }

    public RobertaTokenizationUpdate(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public Tokenization apply(Tokenization originalConfig) {
        if (originalConfig instanceof RobertaTokenization) {
            RobertaTokenization robertaTokenization = (RobertaTokenization)originalConfig;
            if (this.isNoop()) {
                return robertaTokenization;
            }
            Tokenization.validateSpanAndTruncate(this.getTruncate(), this.getSpan());
            if (this.getTruncate() != null && !this.getTruncate().isInCompatibleWithSpan()) {
                return new RobertaTokenization(robertaTokenization.withSpecialTokens(), robertaTokenization.isAddPrefixSpace(), robertaTokenization.maxSequenceLength(), this.getTruncate(), null);
            }
            return new RobertaTokenization(robertaTokenization.withSpecialTokens(), robertaTokenization.isAddPrefixSpace(), robertaTokenization.maxSequenceLength(), Optional.ofNullable(this.getTruncate()).orElse(originalConfig.getTruncate()), Optional.ofNullable(this.getSpan()).orElse(originalConfig.getSpan()));
        }
        throw ExceptionsHelper.badRequestException("Tokenization config of type [{}] can not be updated with a request of type [{}]", originalConfig.getName(), this.getName());
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    static {
        RobertaTokenizationUpdate.declareCommonParserFields(PARSER);
    }
}

