/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.LenientlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.StrictlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LenientlyParsedTrainedModel;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.StrictlyParsedTrainedModel;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModel;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class TrainedModelDefinition
implements ToXContentObject,
Writeable,
Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(TrainedModelDefinition.class);
    public static final String NAME = "trained_model_definition";
    public static final ParseField TRAINED_MODEL = new ParseField("trained_model", new String[0]);
    public static final ParseField PREPROCESSORS = new ParseField("preprocessors", new String[0]);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = TrainedModelDefinition.createParser(true);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = TrainedModelDefinition.createParser(false);
    private final TrainedModel trainedModel;
    private final List<PreProcessor> preProcessors;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser(NAME, ignoreUnknownFields, Builder::builderForParser);
        parser.declareNamedObject(Builder::setTrainedModel, (p, c, n) -> ignoreUnknownFields ? (TrainedModel)p.namedObject(LenientlyParsedTrainedModel.class, n, null) : (TrainedModel)p.namedObject(StrictlyParsedTrainedModel.class, n, null), TRAINED_MODEL);
        parser.declareNamedObjects(Builder::setPreProcessors, (p, c, n) -> ignoreUnknownFields ? (PreProcessor)p.namedObject(LenientlyParsedPreProcessor.class, n, (Object)PreProcessor.PreProcessorParseContext.DEFAULT) : (PreProcessor)p.namedObject(StrictlyParsedPreProcessor.class, n, (Object)PreProcessor.PreProcessorParseContext.DEFAULT), trainedModelDefBuilder -> trainedModelDefBuilder.setProcessorsInOrder(true), PREPROCESSORS);
        return parser;
    }

    public static Builder fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (Builder)LENIENT_PARSER.parse(parser, null) : (Builder)STRICT_PARSER.parse(parser, null);
    }

    private TrainedModelDefinition(TrainedModel trainedModel, List<PreProcessor> preProcessors) {
        this.trainedModel = ExceptionsHelper.requireNonNull(trainedModel, TRAINED_MODEL);
        this.preProcessors = preProcessors == null ? Collections.emptyList() : Collections.unmodifiableList(preProcessors);
    }

    public TrainedModelDefinition(StreamInput in) throws IOException {
        this.trainedModel = (TrainedModel)in.readNamedWriteable(TrainedModel.class);
        this.preProcessors = in.readNamedWriteableCollectionAsList(PreProcessor.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.trainedModel);
        out.writeNamedWriteableCollection(this.preProcessors);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        NamedXContentObjectHelper.writeNamedObjects(builder, params, false, TRAINED_MODEL.getPreferredName(), Collections.singletonList(this.trainedModel));
        NamedXContentObjectHelper.writeNamedObjects(builder, params, true, PREPROCESSORS.getPreferredName(), this.preProcessors);
        builder.endObject();
        return builder;
    }

    public TrainedModel getTrainedModel() {
        return this.trainedModel;
    }

    public List<PreProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelDefinition that = (TrainedModelDefinition)o;
        return Objects.equals(this.trainedModel, that.trainedModel) && Objects.equals(this.preProcessors, that.preProcessors);
    }

    public int hashCode() {
        return Objects.hash(this.trainedModel, this.preProcessors);
    }

    public long ramBytesUsed() {
        long size = SHALLOW_SIZE;
        size += RamUsageEstimator.sizeOf((Accountable)this.trainedModel);
        return size += RamUsageEstimator.sizeOfCollection(this.preProcessors);
    }

    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> accountables = new ArrayList<Accountable>(this.preProcessors.size() + 2);
        accountables.add(Accountables.namedAccountable((String)"trained_model", (Accountable)this.trainedModel));
        for (PreProcessor preProcessor : this.preProcessors) {
            accountables.add(Accountables.namedAccountable((String)("pre_processor_" + preProcessor.getName()), (Accountable)preProcessor));
        }
        return accountables;
    }

    public static class Builder {
        private List<PreProcessor> preProcessors;
        private TrainedModel trainedModel;
        private boolean processorsInOrder;

        private static Builder builderForParser() {
            return new Builder(false);
        }

        private Builder(boolean processorsInOrder) {
            this.processorsInOrder = processorsInOrder;
        }

        public Builder() {
            this(true);
        }

        public Builder(TrainedModelDefinition definition) {
            this(true);
            this.preProcessors = new ArrayList<PreProcessor>(definition.getPreProcessors());
            this.trainedModel = definition.trainedModel;
        }

        public Builder setPreProcessors(List<PreProcessor> preProcessors) {
            this.preProcessors = preProcessors;
            return this;
        }

        public Builder setTrainedModel(TrainedModel trainedModel) {
            this.trainedModel = trainedModel;
            return this;
        }

        private void setProcessorsInOrder(boolean value) {
            this.processorsInOrder = value;
        }

        public TrainedModelDefinition build() {
            if (this.preProcessors != null && this.preProcessors.size() > 1 && !this.processorsInOrder) {
                throw new IllegalArgumentException("preprocessors must be an array of preprocessor objects");
            }
            return new TrainedModelDefinition(this.trainedModel, this.preProcessors);
        }
    }
}

