/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationFields;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationParameters;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public interface Evaluation
extends ToXContentObject,
NamedWriteable {
    public String getName();

    public EvaluationFields getFields();

    public List<? extends EvaluationMetric> getMetrics();

    default public <T extends EvaluationMetric> List<T> initMetrics(@Nullable List<T> parsedMetrics, Supplier<List<T>> defaultMetricsSupplier) {
        List<T> metrics;
        List<T> list = metrics = parsedMetrics == null ? defaultMetricsSupplier.get() : new ArrayList<T>(parsedMetrics);
        if (metrics.isEmpty()) {
            throw ExceptionsHelper.badRequestException("[{}] must have one or more metrics", this.getName());
        }
        Collections.sort(metrics, Comparator.comparing(EvaluationMetric::getName));
        this.checkRequiredFieldsAreSet(metrics);
        return metrics;
    }

    private <T extends EvaluationMetric> void checkRequiredFieldsAreSet(List<T> metrics) {
        if (!1.$assertionsDisabled && (metrics == null || metrics.isEmpty())) {
            throw new AssertionError();
        }
        for (Tuple<String, String> requiredField : this.getFields().listPotentiallyRequiredFields()) {
            String metricNamesString;
            String fieldDescriptor = (String)requiredField.v1();
            String field = (String)requiredField.v2();
            if (field != null || (metricNamesString = metrics.stream().filter(m -> m.getRequiredFields().contains(fieldDescriptor)).map(EvaluationMetric::getName).collect(Collectors.joining(", "))).isEmpty()) continue;
            throw ExceptionsHelper.badRequestException("[{}] must define [{}] as required by the following metrics [{}]", this.getName(), fieldDescriptor, metricNamesString);
        }
    }

    default public SearchSourceBuilder buildSearch(EvaluationParameters parameters, QueryBuilder userProvidedQueryBuilder) {
        Objects.requireNonNull(userProvidedQueryBuilder);
        HashSet<String> requiredFields = new HashSet<String>(this.getRequiredFields());
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (this.getFields().getActualField() != null && requiredFields.contains(this.getFields().getActualField())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.existsQuery((String)this.getFields().getActualField()));
        }
        if (this.getFields().getPredictedField() != null && requiredFields.contains(this.getFields().getPredictedField())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.existsQuery((String)this.getFields().getPredictedField()));
        }
        if (this.getFields().getPredictedClassField() != null && requiredFields.contains(this.getFields().getPredictedClassField())) {
            if (!1.$assertionsDisabled && this.getFields().getTopClassesField() == null) {
                throw new AssertionError();
            }
            ExistsQueryBuilder predictedClassFieldExistsQuery = QueryBuilders.existsQuery((String)this.getFields().getPredictedClassField());
            boolQuery.filter((QueryBuilder)QueryBuilders.nestedQuery((String)this.getFields().getTopClassesField(), (QueryBuilder)predictedClassFieldExistsQuery, (ScoreMode)ScoreMode.None).ignoreUnmapped(true));
        }
        if (this.getFields().getPredictedProbabilityField() != null && requiredFields.contains(this.getFields().getPredictedProbabilityField())) {
            ExistsQueryBuilder predictedProbabilityFieldExistsQuery = QueryBuilders.existsQuery((String)this.getFields().getPredictedProbabilityField());
            if (this.getFields().isPredictedProbabilityFieldNested()) {
                if (!1.$assertionsDisabled && this.getFields().getTopClassesField() == null) {
                    throw new AssertionError();
                }
                boolQuery.filter((QueryBuilder)QueryBuilders.nestedQuery((String)this.getFields().getTopClassesField(), (QueryBuilder)predictedProbabilityFieldExistsQuery, (ScoreMode)ScoreMode.None).ignoreUnmapped(true));
            } else {
                boolQuery.filter((QueryBuilder)predictedProbabilityFieldExistsQuery);
            }
        }
        boolQuery.filter(userProvidedQueryBuilder);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).query((QueryBuilder)boolQuery);
        for (EvaluationMetric evaluationMetric : this.getMetrics()) {
            Tuple<List<AggregationBuilder>, List<PipelineAggregationBuilder>> aggs = evaluationMetric.aggs(parameters, this.getFields());
            ((List)aggs.v1()).forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
            ((List)aggs.v2()).forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
        }
        return searchSourceBuilder;
    }

    default public void process(SearchResponse searchResponse) {
        Objects.requireNonNull(searchResponse);
        if (searchResponse.getHits().getTotalHits().value() == 0L) {
            String requiredFieldsString = String.join((CharSequence)", ", this.getRequiredFields());
            throw ExceptionsHelper.badRequestException("No documents found containing all the required fields [{}]", requiredFieldsString);
        }
        for (EvaluationMetric evaluationMetric : this.getMetrics()) {
            evaluationMetric.process(searchResponse.getAggregations());
        }
    }

    private List<String> getRequiredFields() {
        Set requiredFieldDescriptors = this.getMetrics().stream().map(EvaluationMetric::getRequiredFields).flatMap(Collection::stream).collect(Collectors.toSet());
        List<String> requiredFields = this.getFields().listPotentiallyRequiredFields().stream().filter(f -> requiredFieldDescriptors.contains(f.v1())).map(Tuple::v2).collect(Collectors.toList());
        return requiredFields;
    }

    default public boolean hasAllResults() {
        return this.getMetrics().stream().map(EvaluationMetric::getResult).allMatch(Optional::isPresent);
    }

    default public List<EvaluationMetricResult> getResults() {
        return this.getMetrics().stream().map(EvaluationMetric::getResult).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

