/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Detector;

public class ValidateDetectorAction
extends ActionType<AcknowledgedResponse> {
    public static final ValidateDetectorAction INSTANCE = new ValidateDetectorAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/validate/detector";

    protected ValidateDetectorAction() {
        super(NAME);
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        private Detector detector;

        public static Request parseRequest(XContentParser parser) {
            Detector detector = ((Detector.Builder)Detector.STRICT_PARSER.apply(parser, null)).build();
            return new Request(detector);
        }

        public Request() {
            this.detector = null;
        }

        public Request(Detector detector) {
            this.detector = detector;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.detector = new Detector(in);
        }

        public Detector getDetector() {
            return this.detector;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.detector.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.detector.toXContent(builder, params);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.detector);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.detector, other.detector);
        }
    }
}

