/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public record ChatCompletionResults(List<Result> results) implements InferenceServiceResults
{
    public static final String NAME = "chat_completion_service_results";
    public static final String COMPLETION = TaskType.COMPLETION.name().toLowerCase(Locale.ROOT);

    public ChatCompletionResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(Result::new));
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContentHelper.array((String)COMPLETION, this.results.iterator());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.results);
    }

    public String getWriteableName() {
        return NAME;
    }

    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return this.results;
    }

    public List<? extends InferenceResults> transformToLegacyFormat() {
        throw new UnsupportedOperationException();
    }

    public List<Result> getResults() {
        return this.results;
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(COMPLETION, this.results.stream().map(Result::asMap).collect(Collectors.toList()));
        return map;
    }

    public record Result(String content) implements InferenceResults,
    Writeable
    {
        public static final String RESULT = "result";

        public Result(StreamInput in) throws IOException {
            this(in.readString());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.content);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(RESULT, this.content);
            builder.endObject();
            return builder;
        }

        public String getResultsField() {
            return RESULT;
        }

        public Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(RESULT, this.content);
            return map;
        }

        public Map<String, Object> asMap(String outputField) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(outputField, this.content);
            return map;
        }

        public Object predictedValue() {
            return this.content;
        }

        public String getWriteableName() {
            return ChatCompletionResults.NAME;
        }
    }
}

