/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.deprecation;

import java.util.function.Predicate;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;

public class DeprecatedIndexPredicate {
    public static final IndexVersion MINIMUM_WRITEABLE_VERSION_AFTER_UPGRADE = IndexVersions.UPGRADE_TO_LUCENE_10_0_0;

    public static Predicate<Index> getReindexRequiredPredicate(Metadata metadata, boolean filterToBlockedStatus, boolean includeSystem) {
        return index -> {
            IndexMetadata indexMetadata = metadata.index(index);
            return DeprecatedIndexPredicate.reindexRequired(indexMetadata, filterToBlockedStatus, includeSystem);
        };
    }

    public static boolean reindexRequired(IndexMetadata indexMetadata, boolean filterToBlockedStatus, boolean includeSystem) {
        return DeprecatedIndexPredicate.creationVersionBeforeMinimumWritableVersion(indexMetadata) && (includeSystem || DeprecatedIndexPredicate.isNotSystem(indexMetadata)) && DeprecatedIndexPredicate.isNotSearchableSnapshot(indexMetadata) && DeprecatedIndexPredicate.matchBlockedStatus(indexMetadata, filterToBlockedStatus);
    }

    private static boolean isNotSystem(IndexMetadata indexMetadata) {
        return !indexMetadata.isSystem();
    }

    private static boolean isNotSearchableSnapshot(IndexMetadata indexMetadata) {
        return !indexMetadata.isSearchableSnapshot();
    }

    private static boolean creationVersionBeforeMinimumWritableVersion(IndexMetadata metadata) {
        return metadata.getCreationVersion().before((VersionId)MINIMUM_WRITEABLE_VERSION_AFTER_UPGRADE);
    }

    private static boolean matchBlockedStatus(IndexMetadata indexMetadata, boolean filterToBlockedStatus) {
        return (Boolean)MetadataIndexStateService.VERIFIED_READ_ONLY_SETTING.get(indexMetadata.getSettings()) == filterToBlockedStatus;
    }
}

