/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.ql.util.LoggingUtils;
import org.elasticsearch.xpack.sql.action.SqlQueryAction;
import org.elasticsearch.xpack.sql.action.SqlQueryRequest;
import org.elasticsearch.xpack.sql.plugin.SqlResponseListener;

@ServerlessScope(value=Scope.PUBLIC)
public class RestSqlQueryAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(RestSqlQueryAction.class);

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_sql"), new RestHandler.Route(RestRequest.Method.POST, "/_sql"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SqlQueryRequest sqlRequest;
        try (XContentParser parser = request.contentOrSourceParamParser();){
            sqlRequest = SqlQueryRequest.fromXContent((XContentParser)parser);
        }
        return channel -> {
            RestCancellableNodeClient cancellableClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancellableClient.execute((ActionType)SqlQueryAction.INSTANCE, (ActionRequest)sqlRequest, new SqlResponseListener((RestChannel)channel, request, sqlRequest).delegateResponse((l, ex) -> {
                LoggingUtils.logOnFailure((Logger)LOGGER, (Throwable)ex);
                l.onFailure(ex);
            }));
        };
    }

    protected Set<String> responseParams() {
        return Collections.singleton("delimiter");
    }

    public String getName() {
        return "sql_query";
    }
}

