/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.Base64;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;

public class SqlStreamInput
extends NamedWriteableAwareStreamInput {
    private final ZoneId zoneId;

    public static SqlStreamInput fromString(String base64encoded, NamedWriteableRegistry namedWriteableRegistry, TransportVersion version) throws IOException {
        byte[] bytes = Base64.getDecoder().decode(base64encoded);
        StreamInput in = StreamInput.wrap((byte[])bytes);
        TransportVersion inVersion = TransportVersion.readVersion((StreamInput)in);
        SqlStreamInput.validateStreamVersion(version, inVersion);
        return new SqlStreamInput(CompressorFactory.COMPRESSOR.threadLocalStreamInput((InputStream)in), namedWriteableRegistry, inVersion);
    }

    private static void validateStreamVersion(TransportVersion version, TransportVersion cursorVersion) {
        if (cursorVersion.before((VersionId)TransportVersions.V_8_8_0) && !version.equals((Object)cursorVersion)) {
            throw new SqlIllegalArgumentException("Unsupported cursor version [{}], expected [{}]", cursorVersion, version);
        }
    }

    private SqlStreamInput(StreamInput input, NamedWriteableRegistry namedWriteableRegistry, TransportVersion version) throws IOException {
        super(input, namedWriteableRegistry);
        this.delegate.setTransportVersion(version);
        this.zoneId = this.delegate.readZoneId();
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public static SqlStreamInput asSqlStream(StreamInput in) {
        if (in instanceof SqlStreamInput) {
            return (SqlStreamInput)in;
        }
        throw new SqlIllegalArgumentException("Expected SQL cursor stream, received [{}]", in.getClass());
    }
}

