/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.profiling.action.NumberUtils;
import org.elasticsearch.xpack.profiling.action.TopNFunction;

public class GetTopNFunctionsResponse
extends ActionResponse
implements ToXContentObject {
    private final long selfCount;
    private final long totalCount;
    private final double annualCo2Tons;
    private final double annualCostsUsd;
    private final List<TopNFunction> topNFunctions;

    public GetTopNFunctionsResponse(long selfCount, long totalCount, double annualCo2Tons, double annualCostsUsd, List<TopNFunction> topNFunctions) {
        this.selfCount = selfCount;
        this.totalCount = totalCount;
        this.annualCo2Tons = annualCo2Tons;
        this.annualCostsUsd = annualCostsUsd;
        this.topNFunctions = topNFunctions;
    }

    public void writeTo(StreamOutput out) {
        TransportAction.localOnly();
    }

    public long getSelfCount() {
        return this.selfCount;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public double getAnnualCo2Tons() {
        return this.annualCo2Tons;
    }

    public double getAnnualCostsUsd() {
        return this.annualCostsUsd;
    }

    public List<TopNFunction> getTopN() {
        return this.topNFunctions;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("self_count", this.selfCount);
        builder.field("total_count", this.totalCount);
        builder.field("self_annual_co2_tons").rawValue(NumberUtils.doubleToString(this.annualCo2Tons));
        builder.field("self_annual_cost_usd").rawValue(NumberUtils.doubleToString(this.annualCostsUsd));
        builder.xContentList("topn", this.topNFunctions);
        builder.endObject();
        return builder;
    }
}

