/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.filtering;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class FilteringValidation
implements Writeable,
ToXContentObject {
    private final List<String> ids;
    private final List<String> messages;
    private static final ParseField IDS_FIELD = new ParseField("ids", new String[0]);
    private static final ParseField MESSAGES_FIELD = new ParseField("messages", new String[0]);
    private static final ConstructingObjectParser<FilteringValidation, Void> PARSER = new ConstructingObjectParser("connector_filtering_validation", true, args -> new Builder().setIds((List)args[0]).setMessages((List)args[1]).build());

    public FilteringValidation(List<String> ids, List<String> messages) {
        this.ids = ids;
        this.messages = messages;
    }

    public FilteringValidation(StreamInput in) throws IOException {
        this.ids = in.readStringCollectionAsList();
        this.messages = in.readStringCollectionAsList();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.stringListField(IDS_FIELD.getPreferredName(), this.ids);
        builder.stringListField(MESSAGES_FIELD.getPreferredName(), this.messages);
        builder.endObject();
        return builder;
    }

    public static FilteringValidation fromXContent(XContentParser parser) throws IOException {
        return (FilteringValidation)PARSER.parse(parser, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.ids);
        out.writeStringCollection(this.messages);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringValidation that = (FilteringValidation)o;
        return Objects.equals(this.ids, that.ids) && Objects.equals(this.messages, that.messages);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.messages);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), IDS_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), MESSAGES_FIELD);
    }

    public static class Builder {
        private List<String> ids;
        private List<String> messages;

        public Builder setIds(List<String> ids) {
            this.ids = ids;
            return this;
        }

        public Builder setMessages(List<String> messages) {
            this.messages = messages;
            return this;
        }

        public FilteringValidation build() {
            return new FilteringValidation(this.ids, this.messages);
        }
    }
}

