/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.xpack.application.analytics.AnalyticsCollection;

@Deprecated
public class AnalyticsCollectionResolver {
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final ClusterService clusterService;

    @Inject
    public AnalyticsCollectionResolver(IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.clusterService = clusterService;
    }

    public AnalyticsCollection collection(String collectionName) throws ResourceNotFoundException {
        return this.collection(this.clusterService.state(), collectionName);
    }

    public AnalyticsCollection collection(ClusterState state, String collectionName) throws ResourceNotFoundException {
        AnalyticsCollection collection = new AnalyticsCollection(collectionName);
        if (!state.metadata().dataStreams().containsKey(collection.getEventDataStream())) {
            throw new ResourceNotFoundException("no such analytics collection [{}]", new Object[]{collectionName});
        }
        return collection;
    }

    public List<AnalyticsCollection> collections(ClusterState state, String ... expressions) {
        List dataStreams = this.indexNameExpressionResolver.dataStreamNames(state, IndicesOptions.lenientExpandOpenNoSelectors(), new String[]{"behavioral_analytics-events-*"});
        Map collections = dataStreams.stream().map(AnalyticsCollection::fromDataStreamName).filter(analyticsCollection -> AnalyticsCollectionResolver.matchAnyExpression(analyticsCollection, expressions)).collect(Collectors.toMap(AnalyticsCollection::getName, Function.identity()));
        List<String> missingCollections = Arrays.stream(expressions).filter(Predicate.not(Regex::isMatchAllPattern)).filter(Predicate.not(Regex::isSimpleMatchPattern)).filter(Predicate.not(collections::containsKey)).toList();
        if (!missingCollections.isEmpty()) {
            throw new ResourceNotFoundException("no such analytics collection [{}] ", new Object[]{missingCollections.get(0)});
        }
        return new ArrayList<AnalyticsCollection>(collections.values());
    }

    private static boolean matchExpression(String collectionName, String expression) {
        if (Strings.isNullOrEmpty((String)expression)) {
            return false;
        }
        if (Regex.isMatchAllPattern((String)expression)) {
            return true;
        }
        if (Regex.isSimpleMatchPattern((String)expression)) {
            return Regex.simpleMatch((String)expression, (String)collectionName);
        }
        return collectionName.equals(expression);
    }

    private static boolean matchAnyExpression(String collectionName, String ... expressions) {
        if (expressions.length < 1) {
            return true;
        }
        return Arrays.stream(expressions).anyMatch(expression -> AnalyticsCollectionResolver.matchExpression(collectionName, expression));
    }

    private static boolean matchAnyExpression(AnalyticsCollection collection, String ... expressions) {
        return AnalyticsCollectionResolver.matchAnyExpression(collection.getName(), expressions);
    }
}

