/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.compute.operator.topn.ValueExtractor;

abstract class ValueExtractorForLong
implements ValueExtractor {
    protected final boolean inKey;

    static ValueExtractorForLong extractorFor(TopNEncoder encoder, boolean inKey, LongBlock block) {
        LongVector vector = block.asVector();
        if (vector != null) {
            return new ForVector(encoder, inKey, vector);
        }
        return new ForBlock(encoder, inKey, block);
    }

    ValueExtractorForLong(TopNEncoder encoder, boolean inKey) {
        assert (encoder == TopNEncoder.DEFAULT_UNSORTABLE) : encoder.toString();
        this.inKey = inKey;
    }

    protected final void writeCount(BreakingBytesRefBuilder values, int count) {
        TopNEncoder.DEFAULT_UNSORTABLE.encodeVInt(count, values);
    }

    protected final void actualWriteValue(BreakingBytesRefBuilder values, long value) {
        TopNEncoder.DEFAULT_UNSORTABLE.encodeLong(value, values);
    }

    static class ForVector
    extends ValueExtractorForLong {
        private final LongVector vector;

        ForVector(TopNEncoder encoder, boolean inKey, LongVector vector) {
            super(encoder, inKey);
            this.vector = vector;
        }

        @Override
        public void writeValue(BreakingBytesRefBuilder values, int position) {
            this.writeCount(values, 1);
            if (this.inKey) {
                return;
            }
            this.actualWriteValue(values, this.vector.getLong(position));
        }
    }

    static class ForBlock
    extends ValueExtractorForLong {
        private final LongBlock block;

        ForBlock(TopNEncoder encoder, boolean inKey, LongBlock block) {
            super(encoder, inKey);
            this.block = block;
        }

        @Override
        public void writeValue(BreakingBytesRefBuilder values, int position) {
            int size = this.block.getValueCount(position);
            this.writeCount(values, size);
            if (size == 1 && this.inKey) {
                return;
            }
            int start = this.block.getFirstValueIndex(position);
            int end = start + size;
            for (int i = start; i < end; ++i) {
                this.actualWriteValue(values, this.block.getLong(i));
            }
        }
    }
}

