/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

public abstract class SortableTopNEncoder
implements TopNEncoder {
    @Override
    public final void encodeLong(long value, BreakingBytesRefBuilder bytesRefBuilder) {
        bytesRefBuilder.grow(bytesRefBuilder.length() + 8);
        NumericUtils.longToSortableBytes((long)value, (byte[])bytesRefBuilder.bytes(), (int)bytesRefBuilder.length());
        bytesRefBuilder.setLength(bytesRefBuilder.length() + 8);
    }

    @Override
    public final long decodeLong(BytesRef bytes) {
        if (bytes.length < 8) {
            throw new IllegalArgumentException("not enough bytes");
        }
        long v = NumericUtils.sortableBytesToLong((byte[])bytes.bytes, (int)bytes.offset);
        bytes.offset += 8;
        bytes.length -= 8;
        return v;
    }

    @Override
    public final void encodeInt(int value, BreakingBytesRefBuilder bytesRefBuilder) {
        bytesRefBuilder.grow(bytesRefBuilder.length() + 4);
        NumericUtils.intToSortableBytes((int)value, (byte[])bytesRefBuilder.bytes(), (int)bytesRefBuilder.length());
        bytesRefBuilder.setLength(bytesRefBuilder.length() + 4);
    }

    @Override
    public final int decodeInt(BytesRef bytes) {
        if (bytes.length < 4) {
            throw new IllegalArgumentException("not enough bytes");
        }
        int v = NumericUtils.sortableBytesToInt((byte[])bytes.bytes, (int)bytes.offset);
        bytes.offset += 4;
        bytes.length -= 4;
        return v;
    }

    @Override
    public final void encodeFloat(float value, BreakingBytesRefBuilder bytesRefBuilder) {
        bytesRefBuilder.grow(bytesRefBuilder.length() + 4);
        NumericUtils.intToSortableBytes((int)NumericUtils.floatToSortableInt((float)value), (byte[])bytesRefBuilder.bytes(), (int)bytesRefBuilder.length());
        bytesRefBuilder.setLength(bytesRefBuilder.length() + 4);
    }

    @Override
    public final float decodeFloat(BytesRef bytes) {
        if (bytes.length < 4) {
            throw new IllegalArgumentException("not enough bytes");
        }
        float v = NumericUtils.sortableIntToFloat((int)NumericUtils.sortableBytesToInt((byte[])bytes.bytes, (int)bytes.offset));
        bytes.offset += 4;
        bytes.length -= 4;
        return v;
    }

    @Override
    public final void encodeDouble(double value, BreakingBytesRefBuilder bytesRefBuilder) {
        bytesRefBuilder.grow(bytesRefBuilder.length() + 8);
        NumericUtils.longToSortableBytes((long)NumericUtils.doubleToSortableLong((double)value), (byte[])bytesRefBuilder.bytes(), (int)bytesRefBuilder.length());
        bytesRefBuilder.setLength(bytesRefBuilder.length() + 8);
    }

    @Override
    public final double decodeDouble(BytesRef bytes) {
        if (bytes.length < 8) {
            throw new IllegalArgumentException("not enough bytes");
        }
        double v = NumericUtils.sortableLongToDouble((long)NumericUtils.sortableBytesToLong((byte[])bytes.bytes, (int)bytes.offset));
        bytes.offset += 8;
        bytes.length -= 8;
        return v;
    }

    @Override
    public final void encodeBoolean(boolean value, BreakingBytesRefBuilder bytesRefBuilder) {
        bytesRefBuilder.append(value ? (byte)1 : 0);
    }

    @Override
    public final boolean decodeBoolean(BytesRef bytes) {
        if (bytes.length < 1) {
            throw new IllegalArgumentException("not enough bytes");
        }
        boolean v = bytes.bytes[bytes.offset] == 1;
        ++bytes.offset;
        --bytes.length;
        return v;
    }
}

