/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.operator.topn.ResultBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

class ResultBuilderForBoolean
implements ResultBuilder {
    private final BooleanBlock.Builder builder;
    private final boolean inKey;
    private boolean key;

    ResultBuilderForBoolean(BlockFactory blockFactory, TopNEncoder encoder, boolean inKey, int initialSize) {
        assert (encoder == TopNEncoder.DEFAULT_UNSORTABLE) : encoder.toString();
        this.inKey = inKey;
        this.builder = blockFactory.newBooleanBlockBuilder(initialSize);
    }

    @Override
    public void decodeKey(BytesRef keys) {
        assert (this.inKey);
        this.key = TopNEncoder.DEFAULT_SORTABLE.decodeBoolean(keys);
    }

    @Override
    public void decodeValue(BytesRef values) {
        int count = TopNEncoder.DEFAULT_UNSORTABLE.decodeVInt(values);
        switch (count) {
            case 0: {
                this.builder.appendNull();
                break;
            }
            case 1: {
                this.builder.appendBoolean(this.inKey ? this.key : this.readValueFromValues(values));
                break;
            }
            default: {
                this.builder.beginPositionEntry();
                for (int i = 0; i < count; ++i) {
                    this.builder.appendBoolean(this.readValueFromValues(values));
                }
                this.builder.endPositionEntry();
            }
        }
    }

    private boolean readValueFromValues(BytesRef values) {
        return TopNEncoder.DEFAULT_UNSORTABLE.decodeBoolean(values);
    }

    @Override
    public BooleanBlock build() {
        return this.builder.build();
    }

    public String toString() {
        return "ResultBuilderForBoolean[inKey=" + this.inKey + "]";
    }

    public void close() {
        this.builder.close();
    }
}

