/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.IsBlockedResult;
import org.elasticsearch.compute.operator.exchange.ExchangeBuffer;
import org.elasticsearch.compute.operator.exchange.ExchangeResponse;
import org.elasticsearch.compute.operator.exchange.ExchangeSink;
import org.elasticsearch.core.RefCounted;

public final class ExchangeSinkHandler {
    private final ExchangeBuffer buffer;
    private final Queue<ActionListener<ExchangeResponse>> listeners = new ConcurrentLinkedQueue<ActionListener<ExchangeResponse>>();
    private final AtomicInteger outstandingSinks = new AtomicInteger();
    private final Semaphore promised = new Semaphore(1);
    private final SubscribableListener<Void> completionFuture;
    private final LongSupplier nowInMillis;
    private final AtomicLong lastUpdatedInMillis;
    private final BlockFactory blockFactory;

    public ExchangeSinkHandler(BlockFactory blockFactory, int maxBufferSize, LongSupplier nowInMillis) {
        this.blockFactory = blockFactory;
        this.buffer = new ExchangeBuffer(maxBufferSize);
        this.completionFuture = SubscribableListener.newForked(this.buffer::addCompletionListener);
        this.nowInMillis = nowInMillis;
        this.lastUpdatedInMillis = new AtomicLong(nowInMillis.getAsLong());
    }

    public void fetchPageAsync(boolean sourceFinished, ActionListener<ExchangeResponse> listener) {
        if (sourceFinished) {
            this.buffer.finish(true);
        }
        this.listeners.add(listener);
        this.onChanged();
        this.notifyListeners();
    }

    public void addCompletionListener(ActionListener<Void> listener) {
        this.completionFuture.addListener(listener);
    }

    public boolean isFinished() {
        return this.completionFuture.isDone();
    }

    void onFailure(Exception failure) {
        this.completionFuture.onFailure(failure);
        this.buffer.finish(true);
        this.notifyListeners();
    }

    private void notifyListeners() {
        while (!this.listeners.isEmpty() && (this.buffer.size() > 0 || this.buffer.noMoreInputs()) && this.promised.tryAcquire()) {
            ExchangeResponse response;
            ActionListener<ExchangeResponse> listener;
            try {
                listener = this.listeners.poll();
                if (listener == null) continue;
                response = new ExchangeResponse(this.blockFactory, this.buffer.pollPage(), this.buffer.isFinished());
            }
            finally {
                this.promised.release();
                continue;
            }
            this.onChanged();
            ActionListener.respondAndRelease(listener, (RefCounted)response);
        }
    }

    public ExchangeSink createExchangeSink(Runnable onPageFetched) {
        return new ExchangeSinkImpl(onPageFetched);
    }

    boolean hasData() {
        return this.outstandingSinks.get() > 0 || this.buffer.size() > 0;
    }

    boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    private void onChanged() {
        this.lastUpdatedInMillis.accumulateAndGet(this.nowInMillis.getAsLong(), Math::max);
    }

    long lastUpdatedTimeInMillis() {
        return this.lastUpdatedInMillis.get();
    }

    public int bufferSize() {
        return this.buffer.size();
    }

    private class ExchangeSinkImpl
    implements ExchangeSink {
        boolean finished;
        private final Runnable onPageFetched;
        private final SubscribableListener<Void> onFinished = new SubscribableListener();

        ExchangeSinkImpl(Runnable onPageFetched) {
            this.onPageFetched = onPageFetched;
            ExchangeSinkHandler.this.onChanged();
            ExchangeSinkHandler.this.buffer.addCompletionListener((ActionListener<Void>)this.onFinished);
            ExchangeSinkHandler.this.outstandingSinks.incrementAndGet();
        }

        @Override
        public void addPage(Page page) {
            this.onPageFetched.run();
            ExchangeSinkHandler.this.buffer.addPage(page);
            ExchangeSinkHandler.this.notifyListeners();
        }

        @Override
        public void finish() {
            if (!this.finished) {
                this.finished = true;
                this.onFinished.onResponse(null);
                ExchangeSinkHandler.this.onChanged();
                if (ExchangeSinkHandler.this.outstandingSinks.decrementAndGet() == 0) {
                    ExchangeSinkHandler.this.buffer.finish(false);
                    ExchangeSinkHandler.this.notifyListeners();
                }
            }
        }

        @Override
        public boolean isFinished() {
            return this.onFinished.isDone();
        }

        @Override
        public void addCompletionListener(ActionListener<Void> listener) {
            this.onFinished.addListener(listener);
        }

        @Override
        public IsBlockedResult waitForWriting() {
            return ExchangeSinkHandler.this.buffer.waitForWriting();
        }
    }
}

