/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVectorBlock;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public final class FloatVectorBlock
extends AbstractVectorBlock
implements FloatBlock {
    private final FloatVector vector;

    FloatVectorBlock(FloatVector vector) {
        this.vector = vector;
    }

    @Override
    public FloatVector asVector() {
        return this.vector;
    }

    @Override
    public float getFloat(int valueIndex) {
        return this.vector.getFloat(valueIndex);
    }

    @Override
    public int getPositionCount() {
        return this.vector.getPositionCount();
    }

    @Override
    public ElementType elementType() {
        return this.vector.elementType();
    }

    @Override
    public FloatBlock filter(int ... positions) {
        return this.vector.filter(positions).asBlock();
    }

    @Override
    public FloatBlock keepMask(BooleanVector mask) {
        return this.vector.keepMask(mask);
    }

    @Override
    public ReleasableIterator<? extends FloatBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return this.vector.lookup(positions, targetBlockSize);
    }

    @Override
    public FloatBlock expand() {
        this.incRef();
        return this;
    }

    public long ramBytesUsed() {
        return this.vector.ramBytesUsed();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FloatBlock) {
            FloatBlock that = (FloatBlock)obj;
            return FloatBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return FloatBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[vector=" + String.valueOf(this.vector) + "]";
    }

    @Override
    public void closeInternal() {
        assert (!this.vector.isReleased()) : "can't release block [" + String.valueOf(this) + "] containing already released vector";
        Releasables.closeExpectNoException((Releasable)this.vector);
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.vector.allowPassingToDifferentDriver();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.vector.blockFactory();
    }
}

