/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefLookup;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.BytesRefVectorBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

final class BytesRefArrayVector
extends AbstractVector
implements BytesRefVector {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BytesRefArrayVector.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRefVectorBlock.class) + (long)Block.PAGE_MEM_OVERHEAD_PER_BLOCK;
    private final BytesRefArray values;

    BytesRefArrayVector(BytesRefArray values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BytesRefArrayVector readArrayVector(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        BytesRefArray values = new BytesRefArray(in, blockFactory.bigArrays());
        boolean success = false;
        try {
            BytesRefArrayVector block = new BytesRefArrayVector(values, positions, blockFactory);
            blockFactory.adjustBreaker(block.ramBytesUsed() - values.bigArraysRamBytesUsed());
            success = true;
            BytesRefArrayVector bytesRefArrayVector = block;
            return bytesRefArrayVector;
        }
        finally {
            if (!success) {
                values.close();
            }
        }
    }

    void writeArrayVector(int positions, StreamOutput out) throws IOException {
        this.values.writeTo(out);
    }

    @Override
    public BytesRefBlock asBlock() {
        return new BytesRefVectorBlock(this);
    }

    @Override
    public OrdinalBytesRefVector asOrdinals() {
        return null;
    }

    @Override
    public BytesRef getBytesRef(int position, BytesRef dest) {
        return this.values.get((long)position, dest);
    }

    @Override
    public ElementType elementType() {
        return ElementType.BYTES_REF;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public BytesRefVector filter(int ... positions) {
        BytesRef scratch = new BytesRef();
        try (BytesRefVector.Builder builder = this.blockFactory().newBytesRefVectorBuilder(positions.length);){
            for (int pos : positions) {
                builder.appendBytesRef(this.values.get((long)pos, scratch));
            }
            BytesRefVector bytesRefVector = builder.build();
            return bytesRefVector;
        }
    }

    @Override
    public BytesRefBlock keepMask(BooleanVector mask) {
        if (this.getPositionCount() == 0) {
            this.incRef();
            return new BytesRefVectorBlock(this);
        }
        if (mask.isConstant()) {
            if (mask.getBoolean(0)) {
                this.incRef();
                return new BytesRefVectorBlock(this);
            }
            return (BytesRefBlock)this.blockFactory().newConstantNullBlock(this.getPositionCount());
        }
        BytesRef scratch = new BytesRef();
        try (BytesRefBlock.Builder builder = this.blockFactory().newBytesRefBlockBuilder(this.getPositionCount());){
            for (int p = 0; p < this.getPositionCount(); ++p) {
                if (mask.getBoolean(p)) {
                    builder.appendBytesRef(this.getBytesRef(p, scratch));
                    continue;
                }
                builder.appendNull();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    public ReleasableIterator<BytesRefBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new BytesRefLookup(this.asBlock(), positions, targetBlockSize);
    }

    public static long ramBytesEstimated(BytesRefArray values) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((Accountable)values);
    }

    public long ramBytesUsed() {
        return BytesRefArrayVector.ramBytesEstimated(this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BytesRefVector) {
            BytesRefVector that = (BytesRefVector)obj;
            return BytesRefVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BytesRefVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + "]";
    }

    @Override
    public void closeInternal() {
        this.blockFactory().adjustBreaker(-this.ramBytesUsed() + this.values.bigArraysRamBytesUsed());
        Releasables.closeExpectNoException((Releasable)this.values);
    }
}

