/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.elasticsearch.compute.data.AbstractBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.CompositeBlock;
import org.elasticsearch.compute.data.DoubleBlockBuilder;
import org.elasticsearch.compute.data.IntBlockBuilder;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.BlockLoader;

public class AggregateMetricDoubleBlockBuilder
extends AbstractBlockBuilder
implements BlockLoader.AggregateMetricDoubleBuilder {
    private DoubleBlockBuilder minBuilder = null;
    private DoubleBlockBuilder maxBuilder = null;
    private DoubleBlockBuilder sumBuilder = null;
    private IntBlockBuilder countBuilder = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AggregateMetricDoubleBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        super(blockFactory);
        try {
            this.minBuilder = new DoubleBlockBuilder(estimatedSize, blockFactory);
            this.maxBuilder = new DoubleBlockBuilder(estimatedSize, blockFactory);
            this.sumBuilder = new DoubleBlockBuilder(estimatedSize, blockFactory);
            this.countBuilder = new IntBlockBuilder(estimatedSize, blockFactory);
            if (this.countBuilder != null) return;
        }
        catch (Throwable throwable) {
            if (this.countBuilder != null) throw throwable;
            Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{this.minBuilder, this.maxBuilder, this.sumBuilder, this.countBuilder});
            throw throwable;
        }
        Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{this.minBuilder, this.maxBuilder, this.sumBuilder, this.countBuilder});
    }

    @Override
    protected int valuesLength() {
        throw new UnsupportedOperationException("Not available on aggregate_metric_double");
    }

    @Override
    protected void growValuesArray(int newSize) {
        throw new UnsupportedOperationException("Not available on aggregate_metric_double");
    }

    @Override
    protected int elementSize() {
        throw new UnsupportedOperationException("Not available on aggregate_metric_double");
    }

    @Override
    public Block.Builder copyFrom(Block block, int beginInclusive, int endExclusive) {
        Block countBlock;
        Block sumBlock;
        Block maxBlock;
        Block minBlock;
        if (block.areAllValuesNull()) {
            minBlock = block;
            maxBlock = block;
            sumBlock = block;
            countBlock = block;
        } else {
            CompositeBlock composite = (CompositeBlock)block;
            minBlock = composite.getBlock(Metric.MIN.getIndex());
            maxBlock = composite.getBlock(Metric.MAX.getIndex());
            sumBlock = composite.getBlock(Metric.SUM.getIndex());
            countBlock = composite.getBlock(Metric.COUNT.getIndex());
        }
        this.minBuilder.copyFrom(minBlock, beginInclusive, endExclusive);
        this.maxBuilder.copyFrom(maxBlock, beginInclusive, endExclusive);
        this.sumBuilder.copyFrom(sumBlock, beginInclusive, endExclusive);
        this.countBuilder.copyFrom(countBlock, beginInclusive, endExclusive);
        return this;
    }

    @Override
    public AbstractBlockBuilder appendNull() {
        this.minBuilder.appendNull();
        this.maxBuilder.appendNull();
        this.sumBuilder.appendNull();
        this.countBuilder.appendNull();
        return this;
    }

    @Override
    public Block.Builder mvOrdering(Block.MvOrdering mvOrdering) {
        this.minBuilder.mvOrdering(mvOrdering);
        this.maxBuilder.mvOrdering(mvOrdering);
        this.sumBuilder.mvOrdering(mvOrdering);
        this.countBuilder.mvOrdering(mvOrdering);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block build() {
        Releasable[] blocks = new Block[4];
        boolean success = false;
        try {
            this.finish();
            blocks[Metric.MIN.getIndex()] = this.minBuilder.build();
            blocks[Metric.MAX.getIndex()] = this.maxBuilder.build();
            blocks[Metric.SUM.getIndex()] = this.sumBuilder.build();
            blocks[Metric.COUNT.getIndex()] = this.countBuilder.build();
            CompositeBlock block = new CompositeBlock((Block[])blocks);
            success = true;
            CompositeBlock compositeBlock = block;
            return compositeBlock;
        }
        finally {
            if (!success) {
                Releasables.closeExpectNoException((Releasable[])blocks);
            }
        }
    }

    @Override
    protected void extraClose() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.minBuilder, this.maxBuilder, this.sumBuilder, this.countBuilder});
    }

    public BlockLoader.DoubleBuilder min() {
        return this.minBuilder;
    }

    public BlockLoader.DoubleBuilder max() {
        return this.maxBuilder;
    }

    public BlockLoader.DoubleBuilder sum() {
        return this.sumBuilder;
    }

    public BlockLoader.IntBuilder count() {
        return this.countBuilder;
    }

    public static enum Metric {
        MIN(0),
        MAX(1),
        SUM(2),
        COUNT(3);

        private final int index;

        private Metric(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public record AggregateMetricDoubleLiteral(Double min, Double max, Double sum, Integer count) {
        public AggregateMetricDoubleLiteral {
            min = min.isNaN() ? null : min;
            max = max.isNaN() ? null : max;
            sum = sum.isNaN() ? null : sum;
        }
    }
}

