/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;

abstract class AbstractNonThreadSafeRefCounted
implements RefCounted,
Releasable {
    private int references = 1;

    AbstractNonThreadSafeRefCounted() {
    }

    public final void incRef() {
        if (!this.hasReferences()) {
            throw new IllegalStateException("can't increase refCount on already released object [" + String.valueOf(this) + "]");
        }
        ++this.references;
    }

    public final boolean tryIncRef() {
        if (!this.hasReferences()) {
            return false;
        }
        ++this.references;
        return true;
    }

    public final boolean decRef() {
        if (!this.hasReferences()) {
            throw new IllegalStateException("can't release already released object [" + String.valueOf(this) + "]");
        }
        --this.references;
        if (this.references <= 0) {
            this.closeInternal();
            return true;
        }
        return false;
    }

    public final boolean hasReferences() {
        return this.references >= 1;
    }

    public final void close() {
        this.decRef();
    }

    public final boolean isReleased() {
        return !this.hasReferences();
    }

    protected abstract void closeInternal();
}

