/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.util.Locale;
import java.util.function.LongSupplier;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public enum TimeSeriesValuesSourceType implements ValuesSourceType
{
    COUNTER{

        @Override
        public ValuesSource getEmpty() {
            throw new IllegalArgumentException("Cannot use unmapped counter field");
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw new IllegalArgumentException("Cannot use scripts for time-series counters");
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            if (script != null) {
                throw new IllegalArgumentException("Cannot use scripts for time-series counters");
            }
            IndexFieldData<?> indexFieldData = fieldContext.indexFieldData();
            if (indexFieldData instanceof IndexNumericFieldData) {
                IndexNumericFieldData fieldData = (IndexNumericFieldData)indexFieldData;
                return new ValuesSource.Numeric.FieldData(fieldData);
            }
            throw new IllegalArgumentException("Expected numeric type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier nowInMillis) {
            throw new IllegalArgumentException("Cannot replace missing values for time-series counters");
        }
    }
    ,
    POSITION{

        @Override
        public ValuesSource getEmpty() {
            return ValuesSource.GeoPoint.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw AggregationErrors.valuesSourceDoesNotSupportScritps(this.value());
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            return CoreValuesSourceType.GEOPOINT.getField(fieldContext, script);
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier nowInMillis) {
            return CoreValuesSourceType.GEOPOINT.replaceMissing(valuesSource, rawMissing, docValueFormat, nowInMillis);
        }
    };


    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public String typeName() {
        return this.value();
    }
}

