/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.util.Arrays;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.tdigest.arrays.TDigestArrays;
import org.elasticsearch.tdigest.arrays.TDigestByteArray;
import org.elasticsearch.tdigest.arrays.TDigestDoubleArray;
import org.elasticsearch.tdigest.arrays.TDigestIntArray;
import org.elasticsearch.tdigest.arrays.TDigestLongArray;

public class MemoryTrackingTDigestArrays
implements TDigestArrays {
    private final CircuitBreaker breaker;

    public MemoryTrackingTDigestArrays(CircuitBreaker breaker) {
        this.breaker = breaker;
    }

    public void adjustBreaker(long size) {
        if (size > 0L) {
            this.breaker.addEstimateBytesAndMaybeBreak(size, "tdigest-adjust-breaker");
        } else {
            this.breaker.addWithoutBreaking(size);
        }
    }

    public MemoryTrackingTDigestDoubleArray newDoubleArray(int initialSize) {
        this.breaker.addEstimateBytesAndMaybeBreak(MemoryTrackingTDigestDoubleArray.estimatedRamBytesUsed(initialSize), "tdigest-new-double-array");
        return new MemoryTrackingTDigestDoubleArray(this.breaker, initialSize);
    }

    public MemoryTrackingTDigestIntArray newIntArray(int initialSize) {
        this.breaker.addEstimateBytesAndMaybeBreak(MemoryTrackingTDigestIntArray.estimatedRamBytesUsed(initialSize), "tdigest-new-int-array");
        return new MemoryTrackingTDigestIntArray(this.breaker, initialSize);
    }

    public TDigestLongArray newLongArray(int initialSize) {
        this.breaker.addEstimateBytesAndMaybeBreak(MemoryTrackingTDigestLongArray.estimatedRamBytesUsed(initialSize), "tdigest-new-long-array");
        return new MemoryTrackingTDigestLongArray(this.breaker, initialSize);
    }

    public TDigestByteArray newByteArray(int initialSize) {
        this.breaker.addEstimateBytesAndMaybeBreak(MemoryTrackingTDigestByteArray.estimatedRamBytesUsed(initialSize), "tdigest-new-byte-array");
        return new MemoryTrackingTDigestByteArray(this.breaker, initialSize);
    }

    public MemoryTrackingTDigestDoubleArray newDoubleArray(double[] array) {
        this.breaker.addEstimateBytesAndMaybeBreak(MemoryTrackingTDigestDoubleArray.estimatedRamBytesUsed(array.length), "tdigest-new-double-array");
        return new MemoryTrackingTDigestDoubleArray(this.breaker, array);
    }

    public MemoryTrackingTDigestIntArray newIntArray(int[] array) {
        this.breaker.addEstimateBytesAndMaybeBreak(MemoryTrackingTDigestIntArray.estimatedRamBytesUsed(array.length), "tdigest-new-int-array");
        return new MemoryTrackingTDigestIntArray(this.breaker, array);
    }

    private static long estimatedArraySize(long arrayLength, long bytesPerElement) {
        return RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + arrayLength * bytesPerElement));
    }

    public static class MemoryTrackingTDigestDoubleArray
    extends AbstractMemoryTrackingArray
    implements TDigestDoubleArray {
        static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(MemoryTrackingTDigestDoubleArray.class);
        private double[] array;
        private int size;

        public MemoryTrackingTDigestDoubleArray(CircuitBreaker breaker, int initialSize) {
            this(breaker, new double[initialSize]);
        }

        public MemoryTrackingTDigestDoubleArray(CircuitBreaker breaker, double[] array) {
            super(breaker);
            this.array = array;
            this.size = array.length;
        }

        public static long estimatedRamBytesUsed(int size) {
            return SHALLOW_SIZE + MemoryTrackingTDigestArrays.estimatedArraySize(size, 8L);
        }

        public long ramBytesUsed() {
            return MemoryTrackingTDigestDoubleArray.estimatedRamBytesUsed(this.array.length);
        }

        public int size() {
            return this.size;
        }

        public double get(int index) {
            assert (index >= 0 && index < this.size);
            return this.array[index];
        }

        public void set(int index, double value) {
            assert (index >= 0 && index < this.size);
            this.array[index] = value;
        }

        public void add(double value) {
            this.ensureCapacity(this.size + 1);
            this.array[this.size++] = value;
        }

        public void sort() {
            Arrays.sort(this.array, 0, this.size);
        }

        public void resize(int newSize) {
            this.ensureCapacity(newSize);
            if (newSize > this.size) {
                Arrays.fill(this.array, this.size, newSize, 0.0);
            }
            this.size = newSize;
        }

        public void ensureCapacity(int requiredCapacity) {
            if (requiredCapacity > this.array.length) {
                double[] oldArray = this.array;
                long oldRamBytesUsed = this.ramBytesUsed();
                long oldArraySize = RamUsageEstimator.sizeOf((double[])oldArray);
                int newSize = ArrayUtil.oversize((int)requiredCapacity, (int)8);
                long newArraySize = MemoryTrackingTDigestArrays.estimatedArraySize(newSize, 8L);
                this.breaker.addEstimateBytesAndMaybeBreak(newArraySize, "tdigest-new-capacity-double-array");
                this.array = Arrays.copyOf(this.array, newSize);
                this.breaker.addWithoutBreaking(-RamUsageEstimator.sizeOf((double[])oldArray));
                assert (this.ramBytesUsed() - oldRamBytesUsed == newArraySize - oldArraySize) : "ramBytesUsed() should be aligned with manual array calculations";
            }
        }
    }

    public static class MemoryTrackingTDigestIntArray
    extends AbstractMemoryTrackingArray
    implements TDigestIntArray {
        static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(MemoryTrackingTDigestIntArray.class);
        private int[] array;
        private int size;

        public MemoryTrackingTDigestIntArray(CircuitBreaker breaker, int initialSize) {
            this(breaker, new int[initialSize]);
        }

        public MemoryTrackingTDigestIntArray(CircuitBreaker breaker, int[] array) {
            super(breaker);
            this.array = array;
            this.size = array.length;
        }

        public static long estimatedRamBytesUsed(int size) {
            return SHALLOW_SIZE + MemoryTrackingTDigestArrays.estimatedArraySize(size, 4L);
        }

        public long ramBytesUsed() {
            return MemoryTrackingTDigestIntArray.estimatedRamBytesUsed(this.array.length);
        }

        public int size() {
            return this.size;
        }

        public int get(int index) {
            assert (index >= 0 && index < this.size);
            return this.array[index];
        }

        public void set(int index, int value) {
            assert (index >= 0 && index < this.size);
            this.array[index] = value;
        }

        public void resize(int newSize) {
            this.ensureCapacity(newSize);
            if (newSize > this.size) {
                Arrays.fill(this.array, this.size, newSize, 0);
            }
            this.size = newSize;
        }

        private void ensureCapacity(int requiredCapacity) {
            if (requiredCapacity > this.array.length) {
                int[] oldArray = this.array;
                long oldRamBytesUsed = this.ramBytesUsed();
                long oldArraySize = RamUsageEstimator.sizeOf((int[])oldArray);
                int newSize = ArrayUtil.oversize((int)requiredCapacity, (int)4);
                long newArraySize = MemoryTrackingTDigestArrays.estimatedArraySize(newSize, 4L);
                this.breaker.addEstimateBytesAndMaybeBreak(newArraySize, "tdigest-new-capacity-int-array");
                this.array = Arrays.copyOf(this.array, newSize);
                this.breaker.addWithoutBreaking(-RamUsageEstimator.sizeOf((int[])oldArray));
                assert (this.ramBytesUsed() - oldRamBytesUsed == newArraySize - oldArraySize) : "ramBytesUsed() should be aligned with manual array calculations";
            }
        }
    }

    public static class MemoryTrackingTDigestLongArray
    extends AbstractMemoryTrackingArray
    implements TDigestLongArray {
        static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(MemoryTrackingTDigestLongArray.class);
        private long[] array;
        private int size;

        public MemoryTrackingTDigestLongArray(CircuitBreaker breaker, int initialSize) {
            this(breaker, new long[initialSize]);
        }

        public MemoryTrackingTDigestLongArray(CircuitBreaker breaker, long[] array) {
            super(breaker);
            this.array = array;
            this.size = array.length;
        }

        public static long estimatedRamBytesUsed(int size) {
            return SHALLOW_SIZE + MemoryTrackingTDigestArrays.estimatedArraySize(size, 8L);
        }

        public long ramBytesUsed() {
            return MemoryTrackingTDigestLongArray.estimatedRamBytesUsed(this.array.length);
        }

        public int size() {
            return this.size;
        }

        public long get(int index) {
            assert (index >= 0 && index < this.size);
            return this.array[index];
        }

        public void set(int index, long value) {
            assert (index >= 0 && index < this.size);
            this.array[index] = value;
        }

        public void resize(int newSize) {
            this.ensureCapacity(newSize);
            if (newSize > this.size) {
                Arrays.fill(this.array, this.size, newSize, 0L);
            }
            this.size = newSize;
        }

        private void ensureCapacity(int requiredCapacity) {
            if (requiredCapacity > this.array.length) {
                long[] oldArray = this.array;
                long oldRamBytesUsed = this.ramBytesUsed();
                long oldArraySize = RamUsageEstimator.sizeOf((long[])oldArray);
                int newSize = ArrayUtil.oversize((int)requiredCapacity, (int)8);
                long newArraySize = MemoryTrackingTDigestArrays.estimatedArraySize(newSize, 8L);
                this.breaker.addEstimateBytesAndMaybeBreak(newArraySize, "tdigest-new-capacity-long-array");
                this.array = Arrays.copyOf(this.array, newSize);
                this.breaker.addWithoutBreaking(-RamUsageEstimator.sizeOf((long[])oldArray));
                assert (this.ramBytesUsed() - oldRamBytesUsed == newArraySize - oldArraySize) : "ramBytesUsed() should be aligned with manual array calculations";
            }
        }
    }

    public static class MemoryTrackingTDigestByteArray
    extends AbstractMemoryTrackingArray
    implements TDigestByteArray {
        static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(MemoryTrackingTDigestByteArray.class);
        private byte[] array;
        private int size;

        public MemoryTrackingTDigestByteArray(CircuitBreaker breaker, int initialSize) {
            this(breaker, new byte[initialSize]);
        }

        public MemoryTrackingTDigestByteArray(CircuitBreaker breaker, byte[] array) {
            super(breaker);
            this.array = array;
            this.size = array.length;
        }

        public static long estimatedRamBytesUsed(int size) {
            return SHALLOW_SIZE + MemoryTrackingTDigestArrays.estimatedArraySize(size, 1L);
        }

        public long ramBytesUsed() {
            return MemoryTrackingTDigestByteArray.estimatedRamBytesUsed(this.array.length);
        }

        public int size() {
            return this.size;
        }

        public byte get(int index) {
            assert (index >= 0 && index < this.size);
            return this.array[index];
        }

        public void set(int index, byte value) {
            assert (index >= 0 && index < this.size);
            this.array[index] = value;
        }

        public void resize(int newSize) {
            this.ensureCapacity(newSize);
            if (newSize > this.size) {
                Arrays.fill(this.array, this.size, newSize, (byte)0);
            }
            this.size = newSize;
        }

        private void ensureCapacity(int requiredCapacity) {
            if (requiredCapacity > this.array.length) {
                byte[] oldArray = this.array;
                long oldRamBytesUsed = this.ramBytesUsed();
                long oldArraySize = RamUsageEstimator.sizeOf((byte[])oldArray);
                int newSize = ArrayUtil.oversize((int)requiredCapacity, (int)1);
                long newArraySize = MemoryTrackingTDigestArrays.estimatedArraySize(newSize, 1L);
                this.breaker.addEstimateBytesAndMaybeBreak(newArraySize, "tdigest-new-capacity-byte-array");
                this.array = Arrays.copyOf(this.array, newSize);
                this.breaker.addWithoutBreaking(-RamUsageEstimator.sizeOf((byte[])oldArray));
                assert (this.ramBytesUsed() - oldRamBytesUsed == newArraySize - oldArraySize) : "ramBytesUsed() should be aligned with manual array calculations";
            }
        }
    }

    private static abstract class AbstractMemoryTrackingArray
    implements Releasable,
    Accountable {
        protected final CircuitBreaker breaker;
        private boolean closed = false;

        AbstractMemoryTrackingArray(CircuitBreaker breaker) {
            this.breaker = breaker;
        }

        public final void close() {
            if (!this.closed) {
                this.closed = true;
                this.breaker.addWithoutBreaking(-this.ramBytesUsed());
            }
        }
    }
}

