/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.SetBackedScalingCuckooFilter;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.InternalRareTerms;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedRareTerms;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class InternalMappedRareTerms<A extends InternalRareTerms<A, B>, B extends InternalRareTerms.Bucket<B>>
extends InternalRareTerms<A, B> {
    protected DocValueFormat format;
    protected List<B> buckets;
    final SetBackedScalingCuckooFilter filter;

    InternalMappedRareTerms(String name, BucketOrder order, Map<String, Object> metadata, DocValueFormat format, List<B> buckets, long maxDocCount, SetBackedScalingCuckooFilter filter) {
        super(name, order, maxDocCount, metadata);
        this.format = format;
        this.buckets = buckets;
        this.filter = filter;
    }

    SetBackedScalingCuckooFilter getFilter() {
        return this.filter;
    }

    InternalMappedRareTerms(StreamInput in, InternalRareTerms.Bucket.Reader<B> bucketReader) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.buckets = in.readCollectionAsList(stream -> bucketReader.read(stream, this.format));
        this.filter = new SetBackedScalingCuckooFilter(in, Randomness.get());
    }

    @Override
    protected void writeTermTypeInfoTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeCollection(this.buckets);
        this.filter.writeTo(out);
    }

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, int size) {
        return new AggregatorReducer(){
            final Map<Object, List<B>> buckets = new HashMap();
            InternalRareTerms<A, B> referenceTerms = null;
            SetBackedScalingCuckooFilter filter = null;

            @Override
            public void accept(InternalAggregation aggregation) {
                if (!aggregation.canLeadReduction()) {
                    return;
                }
                InternalRareTerms terms = (InternalRareTerms)aggregation;
                if (this.referenceTerms == null && !aggregation.getClass().equals(UnmappedRareTerms.class)) {
                    this.referenceTerms = terms;
                }
                if (this.referenceTerms != null && !this.referenceTerms.getClass().equals(terms.getClass()) && !terms.getClass().equals(UnmappedRareTerms.class)) {
                    throw AggregationErrors.reduceTypeMismatch(this.referenceTerms.getName(), Optional.empty());
                }
                for (InternalRareTerms.Bucket bucket : terms.getBuckets()) {
                    List bucketList = this.buckets.computeIfAbsent(bucket.getKey(), k -> new ArrayList());
                    bucketList.add(bucket);
                }
                SetBackedScalingCuckooFilter otherFilter = ((InternalMappedRareTerms)aggregation).getFilter();
                if (this.filter == null) {
                    this.filter = new SetBackedScalingCuckooFilter(otherFilter.getThreshold(), otherFilter.getRng(), otherFilter.getFpp());
                }
                this.filter.merge(otherFilter);
            }

            @Override
            public InternalAggregation get() {
                ArrayList rare = new ArrayList();
                for (List sameTermBuckets : this.buckets.values()) {
                    Object b = InternalMappedRareTerms.this.reduceBucket(sameTermBuckets, reduceContext);
                    if (((InternalRareTerms.Bucket)b).getDocCount() <= InternalMappedRareTerms.this.maxDocCount && !InternalMappedRareTerms.this.containsTerm(this.filter, b)) {
                        rare.add(b);
                        reduceContext.consumeBucketsAndMaybeBreak(1);
                        continue;
                    }
                    if (((InternalRareTerms.Bucket)b).getDocCount() <= InternalMappedRareTerms.this.maxDocCount) continue;
                    InternalMappedRareTerms.this.addToFilter(this.filter, b);
                }
                CollectionUtil.introSort(rare, InternalMappedRareTerms.this.order.comparator());
                return InternalMappedRareTerms.this.createWithFilter(InternalMappedRareTerms.this.name, rare, this.filter);
            }
        };
    }

    private B reduceBucket(List<B> buckets, AggregationReduceContext context) {
        assert (!buckets.isEmpty());
        long docCount = 0L;
        for (InternalRareTerms.Bucket bucket : buckets) {
            docCount += bucket.docCount;
        }
        InternalMultiBucketAggregation.BucketAggregationList<B> aggregations = new InternalMultiBucketAggregation.BucketAggregationList<B>(buckets);
        InternalAggregations aggs = InternalAggregations.reduce(aggregations, context);
        return (B)this.createBucket(docCount, aggs, (InternalRareTerms.Bucket)buckets.get(0));
    }

    public A finalizeSampling(SamplingContext samplingContext) {
        List<B> originalBuckets = this.getBuckets();
        ArrayList<InternalRareTerms.Bucket> buckets = new ArrayList<InternalRareTerms.Bucket>(originalBuckets.size());
        for (InternalRareTerms.Bucket bucket : originalBuckets) {
            buckets.add(this.createBucket(samplingContext.scaleUp(bucket.getDocCount()), InternalAggregations.finalizeSampling(bucket.aggregations, samplingContext), bucket));
        }
        return this.createWithFilter(this.name, buckets, this.filter);
    }

    public abstract boolean containsTerm(SetBackedScalingCuckooFilter var1, B var2);

    public abstract void addToFilter(SetBackedScalingCuckooFilter var1, B var2);

    @Override
    public List<B> getBuckets() {
        return this.buckets;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalMappedRareTerms that = (InternalMappedRareTerms)obj;
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.format, that.format) && Objects.equals(this.filter, that.filter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.format, this.filter);
    }

    @Override
    public final XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return InternalMappedRareTerms.doXContentCommon(builder, params, this.buckets);
    }
}

