/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.BucketReducer;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;

public abstract class FixedMultiBucketAggregatorsReducer<B extends MultiBucketsAggregation.Bucket>
implements Releasable {
    private final List<BucketReducer<B>> bucketReducer;

    public FixedMultiBucketAggregatorsReducer(AggregationReduceContext reduceContext, int size, List<B> protoList) {
        reduceContext.consumeBucketsAndMaybeBreak(protoList.size());
        this.bucketReducer = new ArrayList<BucketReducer<B>>(protoList.size());
        for (int i = 0; i < protoList.size(); ++i) {
            this.bucketReducer.add(new BucketReducer<MultiBucketsAggregation.Bucket>((MultiBucketsAggregation.Bucket)protoList.get(i), reduceContext, size));
        }
    }

    public final void accept(List<B> buckets) {
        assert (buckets.size() == this.bucketReducer.size());
        for (int i = 0; i < buckets.size(); ++i) {
            this.bucketReducer.get(i).accept((MultiBucketsAggregation.Bucket)buckets.get(i));
        }
    }

    public final List<B> get() {
        ArrayList<B> reduceBuckets = new ArrayList<B>(this.bucketReducer.size());
        for (BucketReducer<B> reducer : this.bucketReducer) {
            reduceBuckets.add(this.createBucket(reducer.getProto(), reducer.getDocCount(), reducer.getAggregations()));
        }
        return reduceBuckets;
    }

    protected abstract B createBucket(B var1, long var2, InternalAggregations var4);

    public final void close() {
        Releasables.close(this.bucketReducer);
    }
}

