/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorsReducer;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;

public final class BucketReducer<B extends MultiBucketsAggregation.Bucket>
implements Releasable {
    private final AggregatorsReducer aggregatorsReducer;
    private final B proto;
    private long count = 0L;

    public BucketReducer(B proto, AggregationReduceContext context, int size) {
        this.aggregatorsReducer = new AggregatorsReducer(proto.getAggregations(), context, size);
        this.proto = proto;
    }

    public void accept(B bucket) {
        this.count += bucket.getDocCount();
        this.aggregatorsReducer.accept(bucket.getAggregations());
    }

    public B getProto() {
        return this.proto;
    }

    public InternalAggregations getAggregations() {
        return this.aggregatorsReducer.get();
    }

    public long getDocCount() {
        return this.count;
    }

    public void close() {
        Releasables.close((Releasable)this.aggregatorsReducer);
    }
}

