/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.DelayedBucket;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;

public abstract class TopBucketBuilder<B extends InternalMultiBucketAggregation.InternalBucket> {
    static final int USE_BUFFERING_BUILDER = 1024;
    protected final Consumer<DelayedBucket<B>> nonCompetitive;

    public static <B extends InternalMultiBucketAggregation.InternalBucket> TopBucketBuilder<B> build(int size, BucketOrder order, Consumer<DelayedBucket<B>> nonCompetitive, BiFunction<List<B>, AggregationReduceContext, B> reduce, AggregationReduceContext reduceContext) {
        if (size < 1024) {
            return new PriorityQueueTopBucketBuilder<B>(size, order, nonCompetitive, reduce, reduceContext);
        }
        return new BufferingTopBucketBuilder<B>(size, order, nonCompetitive, reduce, reduceContext);
    }

    private TopBucketBuilder(Consumer<DelayedBucket<B>> nonCompetitive) {
        this.nonCompetitive = nonCompetitive;
    }

    public abstract void add(DelayedBucket<B> var1);

    public abstract List<B> build();

    static class PriorityQueueTopBucketBuilder<B extends InternalMultiBucketAggregation.InternalBucket>
    extends TopBucketBuilder<B> {
        private final PriorityQueue<DelayedBucket<B>> queue;
        private final BiFunction<List<B>, AggregationReduceContext, B> reduce;
        private final AggregationReduceContext reduceContext;

        PriorityQueueTopBucketBuilder(int size, final BucketOrder order, Consumer<DelayedBucket<B>> nonCompetitive, final BiFunction<List<B>, AggregationReduceContext, B> reduce, final AggregationReduceContext reduceContext) {
            super(nonCompetitive);
            if (size >= ArrayUtil.MAX_ARRAY_LENGTH) {
                throw new IllegalArgumentException("can't reduce more than [" + ArrayUtil.MAX_ARRAY_LENGTH + "] buckets");
            }
            this.reduce = reduce;
            this.reduceContext = reduceContext;
            this.queue = new PriorityQueue<DelayedBucket<B>>(this, size){
                private final Comparator<DelayedBucket<B>> comparator;
                {
                    super(arg0);
                    this.comparator = order.delayedBucketComparator(reduce, reduceContext);
                }

                protected boolean lessThan(DelayedBucket<B> a, DelayedBucket<B> b) {
                    return this.comparator.compare(a, b) > 0;
                }
            };
        }

        @Override
        public void add(DelayedBucket<B> bucket) {
            DelayedBucket removed = (DelayedBucket)this.queue.insertWithOverflow(bucket);
            if (removed != null) {
                this.nonCompetitive.accept(removed);
                removed.nonCompetitive(this.reduceContext);
            } else {
                this.reduceContext.consumeBucketsAndMaybeBreak(1);
            }
        }

        @Override
        public List<B> build() {
            ArrayList<B> result = new ArrayList<B>(this.queue.size());
            for (int i = this.queue.size() - 1; i >= 0; --i) {
                result.add(((DelayedBucket)this.queue.pop()).reduced(this.reduce, this.reduceContext));
            }
            Collections.reverse(result);
            return result;
        }
    }

    private static class BufferingTopBucketBuilder<B extends InternalMultiBucketAggregation.InternalBucket>
    extends TopBucketBuilder<B> {
        private final int size;
        private final BucketOrder order;
        private final BiFunction<List<B>, AggregationReduceContext, B> reduce;
        private final AggregationReduceContext reduceContext;
        private List<DelayedBucket<B>> buffer;
        private PriorityQueueTopBucketBuilder<B> next;

        BufferingTopBucketBuilder(int size, BucketOrder order, Consumer<DelayedBucket<B>> nonCompetitive, BiFunction<List<B>, AggregationReduceContext, B> reduce, AggregationReduceContext reduceContext) {
            super(nonCompetitive);
            this.reduce = reduce;
            this.reduceContext = reduceContext;
            this.size = size;
            this.order = order;
            this.buffer = new ArrayList<DelayedBucket<B>>();
        }

        @Override
        public void add(DelayedBucket<B> bucket) {
            if (this.next != null) {
                assert (this.buffer == null);
                this.next.add(bucket);
                return;
            }
            this.reduceContext.consumeBucketsAndMaybeBreak(1);
            this.buffer.add(bucket);
            if (this.buffer.size() < this.size) {
                return;
            }
            this.next = new PriorityQueueTopBucketBuilder<B>(this.size, this.order, this.nonCompetitive, this.reduce, this.reduceContext);
            for (DelayedBucket<B> b : this.buffer) {
                this.next.queue.add(b);
            }
            this.buffer = null;
        }

        @Override
        public List<B> build() {
            if (this.next != null) {
                assert (this.buffer == null);
                return this.next.build();
            }
            ArrayList<Object> result = new ArrayList<Object>(this.buffer.size());
            for (DelayedBucket<B> b : this.buffer) {
                result.add(b.reduced(this.reduce, this.reduceContext));
            }
            result.sort(this.order.comparator());
            return result;
        }
    }
}

