/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.Iterator;

public interface VectorIterator<E>
extends Iterator<E> {
    public Iterator<E> copy();

    public void reset();

    public static VectorIterator<float[]> from(final float[][] vectors) {
        return new VectorIterator<float[]>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < vectors.length;
            }

            @Override
            public float[] next() {
                return vectors[this.i++];
            }

            @Override
            public Iterator<float[]> copy() {
                return VectorIterator.from(vectors);
            }

            @Override
            public void reset() {
                this.i = 0;
            }
        };
    }

    public static VectorIterator<byte[]> from(final byte[][] vectors) {
        return new VectorIterator<byte[]>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < vectors.length;
            }

            @Override
            public byte[] next() {
                return vectors[this.i++];
            }

            @Override
            public Iterator<byte[]> copy() {
                return VectorIterator.from(vectors);
            }

            @Override
            public void reset() {
                this.i = 0;
            }
        };
    }
}

