/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.DenseVectorScriptDocValues;
import org.elasticsearch.script.field.vectors.ByteBinaryDenseVector;
import org.elasticsearch.script.field.vectors.DenseVector;
import org.elasticsearch.script.field.vectors.DenseVectorDocValuesField;

public class ByteBinaryDenseVectorDocValuesField
extends DenseVectorDocValuesField {
    protected final BinaryDocValues input;
    protected final int dims;
    protected final byte[] vectorValue;
    protected boolean decoded;
    protected BytesRef value;

    public ByteBinaryDenseVectorDocValuesField(BinaryDocValues input, String name, DenseVectorFieldMapper.ElementType elementType, int dims) {
        super(name, elementType);
        this.input = input;
        this.dims = dims;
        this.vectorValue = new byte[dims];
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        this.decoded = false;
        this.value = this.input.advanceExact(docId) ? this.input.binaryValue() : null;
    }

    @Override
    public DenseVectorScriptDocValues toScriptDocValues() {
        return new DenseVectorScriptDocValues(this, this.dims);
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    protected DenseVector getVector() {
        return new ByteBinaryDenseVector(this.vectorValue, this.value, this.dims);
    }

    @Override
    public DenseVector get() {
        if (this.isEmpty()) {
            return DenseVector.EMPTY;
        }
        this.decodeVectorIfNecessary();
        return this.getVector();
    }

    @Override
    public DenseVector get(DenseVector defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        this.decodeVectorIfNecessary();
        return this.getVector();
    }

    @Override
    public DenseVector getInternal() {
        return this.get(null);
    }

    private void decodeVectorIfNecessary() {
        if (!this.decoded && this.value != null) {
            System.arraycopy(this.value.bytes, this.value.offset, this.vectorValue, 0, this.dims);
            this.decoded = true;
        }
    }
}

