/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.script.Metadata;
import org.elasticsearch.script.UpdateMetadata;

class UpsertMetadata
extends UpdateMetadata {
    static final Map<String, Metadata.FieldProperty<?>> PROPERTIES = Map.of("_index", StringField, "_id", StringField, "op", StringField.withWritable().withNullable(), "_now", LongField);

    UpsertMetadata(String index, String id, String op, long now) {
        super(UpsertMetadata.metadataMap(index, id, op, now), Set.of("noop", "create"), PROPERTIES);
    }

    protected static Map<String, Object> metadataMap(String index, String id, String op, long now) {
        Map<String, Object> metadata = Maps.newHashMapWithExpectedSize(PROPERTIES.size());
        metadata.put("_index", index);
        metadata.put("_id", id);
        metadata.put("op", op);
        metadata.put("_now", now);
        return metadata;
    }

    @Override
    public String getRouting() {
        throw new UnsupportedOperationException("routing is unavailable for insert");
    }

    @Override
    public long getVersion() {
        throw new UnsupportedOperationException("version is unavailable for insert");
    }
}

