/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;

public class RestGetFieldMappingAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_mapping/field/{fields}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mapping/field/{fields}"));
    }

    @Override
    public String getName() {
        return "get_field_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final String[] fields = Strings.splitStringByCommaToArray(request.param("fields"));
        GetFieldMappingsRequest getMappingsRequest = new GetFieldMappingsRequest();
        getMappingsRequest.indices(indices).fields(fields).includeDefaults(request.paramAsBoolean("include_defaults", false));
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        return channel -> client.admin().indices().getFieldMappings(getMappingsRequest, (ActionListener<GetFieldMappingsResponse>)new RestBuilderListener<GetFieldMappingsResponse>(this, channel){

            @Override
            public RestResponse buildResponse(GetFieldMappingsResponse response, XContentBuilder builder) throws Exception {
                Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>> mappingsByIndex = response.mappings();
                RestStatus status = RestStatus.OK;
                if (mappingsByIndex.isEmpty() && fields.length > 0) {
                    status = RestStatus.NOT_FOUND;
                }
                response.toXContent(builder, request);
                return new RestResponse(status, builder);
            }
        });
    }
}

